/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.gatling.utils;

import com.eatthepath.uuid.FastUUID;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalUnit;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import ru.tinkoff.gatling.utils.RandomDigitMagnet;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Stream$;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;

public final class RandomDataGenerators$ {
    public static final RandomDataGenerators$ MODULE$ = new RandomDataGenerators$();

    public String randomString(String alphabet, int n) {
        Predef$.MODULE$.require(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(alphabet)), (Function0 & Serializable)() -> "randomString generator required non empty alphabet input");
        Predef$.MODULE$.require(n > 0, (Function0 & Serializable)() -> new StringBuilder(72).append("randomString generator required string length input >0. Current value = ").append(n).toString());
        return Stream$.MODULE$.continually((Function0)(JFunction0.mcI.sp & Serializable)() -> Random$.MODULE$.nextInt(alphabet.length())).map((Function1)Predef$.MODULE$.wrapString(alphabet)).take(n).mkString();
    }

    public String digitString(int n) {
        return this.randomString("0123456789", n);
    }

    public String hexString(int n) {
        return this.randomString("0123456789abcdef", n);
    }

    public String alphanumericString(int stringLength) {
        Predef$.MODULE$.require(stringLength > 0, (Function0 & Serializable)() -> new StringBuilder(72).append("randomString generator required string length input >0. Current value = ").append(stringLength).toString());
        return Random$.MODULE$.alphanumeric().take(stringLength).mkString();
    }

    public String randomCyrillicString(int n) {
        return this.randomString("\u0410\u0411\u0412\u0413\u0414\u0415\u0401\u0416\u0417\u0418\u0419\u041a\u041b\u041c\u041d\u041e\u041f\u0420\u0421\u0422\u0423\u0424\u0425\u0426\u0427\u0428\u0429\u042a\u042b\u042c\u042d\u042e\u042f\u0430\u0431\u0432\u0433\u0434\u0435\u0451\u0436\u0437\u0438\u0439\u043a\u043b\u043c\u043d\u043e\u043f\u0440\u0441\u0442\u0443\u0444\u0445\u0446\u0447\u0448\u0449\u044a\u044b\u044c\u044d\u044e\u044f", n);
    }

    public String randomPhone(String countryCode) {
        return new StringBuilder(0).append(countryCode).append(this.digitString(10)).toString();
    }

    public String randomPhone$default$1() {
        return "+7";
    }

    public int randomDigit() {
        return ThreadLocalRandom.current().nextInt();
    }

    public int randomDigit(int min, int max) {
        Predef$.MODULE$.require(min < max);
        return ThreadLocalRandom.current().nextInt(min, max);
    }

    public long randomDigit(long min, long max) {
        Predef$.MODULE$.require(min < max);
        return ThreadLocalRandom.current().nextLong(min, max);
    }

    public Object randomDigit(RandomDigitMagnet.DigitMagnet magnet) {
        return magnet.RandomImpl();
    }

    public String randomUUID() {
        return FastUUID.toString((UUID)UUID.randomUUID());
    }

    public String randomDate(int positiveDelta, int negativeDelta, String datePattern, LocalDateTime dateFrom, TemporalUnit unit) {
        Predef$.MODULE$.require(positiveDelta >= 0 && negativeDelta >= 0, (Function0 & Serializable)() -> new StringBuilder(91).append("RandomDateFeeder delta requires values >0. Current values: positiveDelta= ").append(positiveDelta).append(", negativeDelta= ").append(negativeDelta).toString());
        return dateFrom.plus(this.randomDigit(-negativeDelta, positiveDelta), unit).format(DateTimeFormatter.ofPattern(datePattern));
    }

    public String randomDate(long offsetDate, String datePattern, LocalDateTime dateFrom, TemporalUnit unit) {
        Predef$.MODULE$.require(offsetDate > 1L, (Function0 & Serializable)() -> new StringBuilder(76).append("RandomRangeDateFeeder offset requires value >1. Current values: offsetDate= ").append(offsetDate).toString());
        return dateFrom.plus(this.randomDigit(1L, offsetDate), unit).format(DateTimeFormatter.ofPattern(datePattern));
    }

    public String randomDate$default$2() {
        return "yyyy-MM-dd";
    }

    private RandomDataGenerators$() {
    }
}

