/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.phobos.decoding;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.Base64;
import java.util.UUID;
import ru.tinkoff.phobos.decoding.AttributeDecoder;
import ru.tinkoff.phobos.decoding.AttributeLiteralInstances;
import ru.tinkoff.phobos.decoding.Cursor;
import ru.tinkoff.phobos.decoding.DecodingError;
import ru.tinkoff.phobos.decoding.package$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.math.BigInt;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.util.Either;

public final class AttributeDecoder$
implements AttributeLiteralInstances {
    public static final AttributeDecoder$ MODULE$ = new AttributeDecoder$();
    private static final AttributeDecoder<String> stringDecoder;
    private static final AttributeDecoder<BoxedUnit> unitDecoder;
    private static final AttributeDecoder<Object> booleanDecoder;
    private static final AttributeDecoder<Boolean> javaBooleanDecoder;
    private static final AttributeDecoder<Object> charDecoder;
    private static final AttributeDecoder<Character> javaCharacterDecoder;
    private static final AttributeDecoder<Object> floatDecoder;
    private static final AttributeDecoder<Float> javaFloatDecoder;
    private static final AttributeDecoder<Object> doubleDecoder;
    private static final AttributeDecoder<Double> javaDoubleDecoder;
    private static final AttributeDecoder<Object> byteDecoder;
    private static final AttributeDecoder<Byte> javaByteDecoder;
    private static final AttributeDecoder<Object> shortDecoder;
    private static final AttributeDecoder<Short> javaShortDecoder;
    private static final AttributeDecoder<Object> intDecoder;
    private static final AttributeDecoder<Integer> javaIntegerDecoder;
    private static final AttributeDecoder<Object> longDecoder;
    private static final AttributeDecoder<Long> javaLongDecoder;
    private static final AttributeDecoder<BigInt> bigIntDecoder;
    private static final AttributeDecoder<BigInteger> javaBigIntegerDecoder;
    private static final AttributeDecoder<scala.math.BigDecimal> bigDecimalDecoder;
    private static final AttributeDecoder<BigDecimal> javaBigDecimalDecoder;
    private static final AttributeDecoder<UUID> UUIDDecoder;
    private static final AttributeDecoder<byte[]> base64Decoder;
    private static final AttributeDecoder<None$> noneDecoder;
    private static final AttributeDecoder<LocalDateTime> localDateTimeDecoder;
    private static final AttributeDecoder<ZonedDateTime> zonedDateTimeDecoder;
    private static final AttributeDecoder<OffsetDateTime> offsetDateTimeDecoder;
    private static final AttributeDecoder<LocalDate> localDateDecoder;
    private static final AttributeDecoder<LocalTime> localTimeDecoder;

    static {
        AttributeLiteralInstances.$init$(MODULE$);
        stringDecoder = new AttributeDecoder<String>(){

            public <B> AttributeDecoder<B> map(Function1<String, B> f) {
                return AttributeDecoder.map$(this, f);
            }

            public <B> AttributeDecoder<B> emap(Function2<List<String>, String, Either<DecodingError, B>> f) {
                return AttributeDecoder.emap$(this, f);
            }

            public Either<DecodingError, String> decodeAsAttribute(Cursor c, String localName, Option<String> namespaceUri) {
                int idx = c.getAttributeIndex((String)namespaceUri.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), localName);
                if (idx > -1) {
                    return scala.package$.MODULE$.Right().apply((Object)c.getAttributeValue(idx));
                }
                return scala.package$.MODULE$.Left().apply((Object)c.error(new StringBuilder(20).append("Missing '").append(localName).append("' attribute").toString()));
            }
            {
                AttributeDecoder.$init$(this);
            }
        };
        unitDecoder = new AttributeDecoder<BoxedUnit>(){

            public <B> AttributeDecoder<B> map(Function1<BoxedUnit, B> f) {
                return AttributeDecoder.map$(this, f);
            }

            public <B> AttributeDecoder<B> emap(Function2<List<String>, BoxedUnit, Either<DecodingError, B>> f) {
                return AttributeDecoder.emap$(this, f);
            }

            public Either<DecodingError, BoxedUnit> decodeAsAttribute(Cursor c, String localName, Option<String> namespaceUri) {
                return scala.package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
            }
            {
                AttributeDecoder.$init$(this);
            }
        };
        booleanDecoder = MODULE$.stringDecoder().emap((Function2 & Serializable)(history, string) -> {
            String string2;
            block8: {
                block9: {
                    string2 = string;
                    switch (string2 == null ? 0 : string2.hashCode()) {
                        case 48: {
                            if (!"0".equals(string2)) break block8;
                            break block9;
                        }
                        case 49: {
                            if ("1".equals(string2)) {
                                break;
                            }
                            break block8;
                        }
                        case 3569038: {
                            if ("true".equals(string2)) {
                                break;
                            }
                            break block8;
                        }
                        case 97196323: {
                            if (!"false".equals(string2)) break block8;
                            break block9;
                        }
                        default: {
                            break block8;
                        }
                    }
                    return scala.package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToBoolean((boolean)true));
                }
                return scala.package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToBoolean((boolean)false));
            }
            return scala.package$.MODULE$.Left().apply((Object)new DecodingError(new StringBuilder(33).append("Value `").append(string2).append("` is not `true` or `false`").toString(), (List<String>)history));
        });
        javaBooleanDecoder = MODULE$.booleanDecoder().map((Function1 & Serializable)x$1 -> Predef$.MODULE$.boolean2Boolean(Predef$.MODULE$.boolean2Boolean(BoxesRunTime.unboxToBoolean((Object)x$1)).booleanValue()));
        charDecoder = MODULE$.stringDecoder().emap((Function2 & Serializable)(history, string) -> {
            if (string.length() != 1) {
                return scala.package$.MODULE$.Left().apply((Object)new DecodingError("Value too long for char", (List<String>)history));
            }
            return scala.package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToCharacter((char)StringOps$.MODULE$.head$extension(Predef$.MODULE$.augmentString(string))));
        });
        javaCharacterDecoder = MODULE$.charDecoder().map((Function1 & Serializable)x$2 -> Predef$.MODULE$.char2Character(Predef$.MODULE$.char2Character(BoxesRunTime.unboxToChar((Object)x$2)).charValue()));
        floatDecoder = MODULE$.stringDecoder().emap(package$.MODULE$.wrapException((Function1 & Serializable)x$3 -> BoxesRunTime.boxToFloat((float)StringOps$.MODULE$.toFloat$extension(Predef$.MODULE$.augmentString(x$3)))));
        javaFloatDecoder = MODULE$.floatDecoder().map((Function1 & Serializable)x$4 -> Predef$.MODULE$.float2Float(BoxesRunTime.unboxToFloat((Object)x$4)));
        doubleDecoder = MODULE$.stringDecoder().emap(package$.MODULE$.wrapException((Function1 & Serializable)x$5 -> BoxesRunTime.boxToDouble((double)StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(x$5)))));
        javaDoubleDecoder = MODULE$.doubleDecoder().map((Function1 & Serializable)x$6 -> Predef$.MODULE$.double2Double(BoxesRunTime.unboxToDouble((Object)x$6)));
        byteDecoder = MODULE$.stringDecoder().emap(package$.MODULE$.wrapException((Function1 & Serializable)x$7 -> BoxesRunTime.boxToByte((byte)StringOps$.MODULE$.toByte$extension(Predef$.MODULE$.augmentString(x$7)))));
        javaByteDecoder = MODULE$.byteDecoder().map((Function1 & Serializable)x$8 -> Predef$.MODULE$.byte2Byte(BoxesRunTime.unboxToByte((Object)x$8)));
        shortDecoder = MODULE$.stringDecoder().emap(package$.MODULE$.wrapException((Function1 & Serializable)x$9 -> BoxesRunTime.boxToShort((short)StringOps$.MODULE$.toShort$extension(Predef$.MODULE$.augmentString(x$9)))));
        javaShortDecoder = MODULE$.shortDecoder().map((Function1 & Serializable)x$10 -> Predef$.MODULE$.short2Short(BoxesRunTime.unboxToShort((Object)x$10)));
        intDecoder = MODULE$.stringDecoder().emap(package$.MODULE$.wrapException((Function1 & Serializable)x$11 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$11)))));
        javaIntegerDecoder = MODULE$.intDecoder().map((Function1 & Serializable)x$12 -> Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)x$12)));
        longDecoder = MODULE$.stringDecoder().emap(package$.MODULE$.wrapException((Function1 & Serializable)x$13 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$13)))));
        javaLongDecoder = MODULE$.longDecoder().map((Function1 & Serializable)x$14 -> Predef$.MODULE$.long2Long(BoxesRunTime.unboxToLong((Object)x$14)));
        bigIntDecoder = MODULE$.stringDecoder().emap(package$.MODULE$.wrapException((Function1 & Serializable)x -> scala.package$.MODULE$.BigInt().apply(x)));
        javaBigIntegerDecoder = MODULE$.stringDecoder().emap(package$.MODULE$.wrapException((Function1 & Serializable)str -> new BigInteger((String)str)));
        bigDecimalDecoder = MODULE$.stringDecoder().map((Function1 & Serializable)x -> scala.package$.MODULE$.BigDecimal().apply(x));
        javaBigDecimalDecoder = MODULE$.bigDecimalDecoder().map((Function1 & Serializable)x$15 -> x$15.bigDecimal());
        UUIDDecoder = MODULE$.stringDecoder().emap(package$.MODULE$.wrapException((Function1 & Serializable)x$1 -> UUID.fromString(x$1)));
        Base64.Decoder decoder = Base64.getDecoder();
        base64Decoder = MODULE$.stringDecoder().emap(package$.MODULE$.wrapException((Function1 & Serializable)x$1 -> decoder.decode((String)x$1)));
        noneDecoder = new AttributeDecoder<None$>(){

            public <B> AttributeDecoder<B> map(Function1<None$, B> f) {
                return AttributeDecoder.map$(this, f);
            }

            public <B> AttributeDecoder<B> emap(Function2<List<String>, None$, Either<DecodingError, B>> f) {
                return AttributeDecoder.emap$(this, f);
            }

            public Either<DecodingError, None$> decodeAsAttribute(Cursor c, String localName, Option<String> namespaceUri) {
                return scala.package$.MODULE$.Right().apply((Object)None$.MODULE$);
            }
            {
                AttributeDecoder.$init$(this);
            }
        };
        localDateTimeDecoder = MODULE$.stringDecoder().emap(package$.MODULE$.wrapException((Function1 & Serializable)x$1 -> LocalDateTime.parse(x$1)));
        zonedDateTimeDecoder = MODULE$.stringDecoder().emap(package$.MODULE$.wrapException((Function1 & Serializable)x$1 -> ZonedDateTime.parse(x$1)));
        offsetDateTimeDecoder = MODULE$.stringDecoder().emap(package$.MODULE$.wrapException((Function1 & Serializable)x$1 -> OffsetDateTime.parse(x$1)));
        localDateDecoder = MODULE$.stringDecoder().emap(package$.MODULE$.wrapException((Function1 & Serializable)x$1 -> LocalDate.parse(x$1)));
        localTimeDecoder = MODULE$.stringDecoder().emap(package$.MODULE$.wrapException((Function1 & Serializable)x$1 -> LocalTime.parse(x$1)));
    }

    @Override
    public <A, L extends A> AttributeDecoder<L> literalDecoder(AttributeDecoder<A> decoder, L valueOfL) {
        return AttributeLiteralInstances.literalDecoder$(this, decoder, valueOfL);
    }

    public <A> AttributeDecoder<A> apply(AttributeDecoder<A> instance) {
        return instance;
    }

    public AttributeDecoder<String> stringDecoder() {
        return stringDecoder;
    }

    public AttributeDecoder<BoxedUnit> unitDecoder() {
        return unitDecoder;
    }

    public AttributeDecoder<Object> booleanDecoder() {
        return booleanDecoder;
    }

    public AttributeDecoder<Boolean> javaBooleanDecoder() {
        return javaBooleanDecoder;
    }

    public AttributeDecoder<Object> charDecoder() {
        return charDecoder;
    }

    public AttributeDecoder<Character> javaCharacterDecoder() {
        return javaCharacterDecoder;
    }

    public AttributeDecoder<Object> floatDecoder() {
        return floatDecoder;
    }

    public AttributeDecoder<Float> javaFloatDecoder() {
        return javaFloatDecoder;
    }

    public AttributeDecoder<Object> doubleDecoder() {
        return doubleDecoder;
    }

    public AttributeDecoder<Double> javaDoubleDecoder() {
        return javaDoubleDecoder;
    }

    public AttributeDecoder<Object> byteDecoder() {
        return byteDecoder;
    }

    public AttributeDecoder<Byte> javaByteDecoder() {
        return javaByteDecoder;
    }

    public AttributeDecoder<Object> shortDecoder() {
        return shortDecoder;
    }

    public AttributeDecoder<Short> javaShortDecoder() {
        return javaShortDecoder;
    }

    public AttributeDecoder<Object> intDecoder() {
        return intDecoder;
    }

    public AttributeDecoder<Integer> javaIntegerDecoder() {
        return javaIntegerDecoder;
    }

    public AttributeDecoder<Object> longDecoder() {
        return longDecoder;
    }

    public AttributeDecoder<Long> javaLongDecoder() {
        return javaLongDecoder;
    }

    public AttributeDecoder<BigInt> bigIntDecoder() {
        return bigIntDecoder;
    }

    public AttributeDecoder<BigInteger> javaBigIntegerDecoder() {
        return javaBigIntegerDecoder;
    }

    public AttributeDecoder<scala.math.BigDecimal> bigDecimalDecoder() {
        return bigDecimalDecoder;
    }

    public AttributeDecoder<BigDecimal> javaBigDecimalDecoder() {
        return javaBigDecimalDecoder;
    }

    public AttributeDecoder<UUID> UUIDDecoder() {
        return UUIDDecoder;
    }

    public AttributeDecoder<byte[]> base64Decoder() {
        return base64Decoder;
    }

    public <A> AttributeDecoder<Option<A>> optionDecoder(AttributeDecoder<A> decoder) {
        return new AttributeDecoder<Option<A>>(decoder){
            private final AttributeDecoder decoder$1;

            public <B> AttributeDecoder<B> map(Function1<Option<A>, B> f) {
                return AttributeDecoder.map$(this, f);
            }

            public <B> AttributeDecoder<B> emap(Function2<List<String>, Option<A>, Either<DecodingError, B>> f) {
                return AttributeDecoder.emap$(this, f);
            }

            public Either<DecodingError, Option<A>> decodeAsAttribute(Cursor c, String localName, Option<String> namespaceUri) {
                int idx = c.getAttributeIndex((String)namespaceUri.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), localName);
                if (idx > -1) {
                    return this.decoder$1.decodeAsAttribute(c, localName, namespaceUri).map((Function1 & Serializable)value -> new Some(value));
                }
                return scala.package$.MODULE$.Right().apply((Object)None$.MODULE$);
            }
            {
                this.decoder$1 = decoder$1;
                AttributeDecoder.$init$(this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$decodeAsAttribute$1(java.lang.Object )}, serializedLambda);
            }
        };
    }

    public <A> AttributeDecoder<Some<A>> someDecoder(AttributeDecoder<A> e) {
        return e.map((Function1 & Serializable)value -> new Some(value));
    }

    public AttributeDecoder<None$> noneDecoder() {
        return noneDecoder;
    }

    public AttributeDecoder<LocalDateTime> localDateTimeDecoder() {
        return localDateTimeDecoder;
    }

    public AttributeDecoder<ZonedDateTime> zonedDateTimeDecoder() {
        return zonedDateTimeDecoder;
    }

    public AttributeDecoder<OffsetDateTime> offsetDateTimeDecoder() {
        return offsetDateTimeDecoder;
    }

    public AttributeDecoder<LocalDate> localDateDecoder() {
        return localDateDecoder;
    }

    public AttributeDecoder<LocalTime> localTimeDecoder() {
        return localTimeDecoder;
    }

    private AttributeDecoder$() {
    }
}

