/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.phobos.decoding;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.UUID;
import ru.tinkoff.phobos.decoding.Cursor;
import ru.tinkoff.phobos.decoding.DecodingError;
import ru.tinkoff.phobos.decoding.DerivedElement;
import ru.tinkoff.phobos.decoding.ElementDecoder;
import ru.tinkoff.phobos.decoding.ElementDecoder$ListDecoder$;
import ru.tinkoff.phobos.decoding.ElementDecoder$StringDecoder$;
import ru.tinkoff.phobos.decoding.ElementLiteralInstances;
import ru.tinkoff.phobos.decoding.package$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.util.Either;

public final class ElementDecoder$
implements ElementLiteralInstances,
DerivedElement {
    public static final ElementDecoder$ MODULE$ = new ElementDecoder$();
    private static final ElementDecoder<String> stringDecoder;
    private static final ElementDecoder<BoxedUnit> unitDecoder;
    private static final ElementDecoder<Object> booleanDecoder;
    private static final ElementDecoder<Boolean> javaBooleanDecoder;
    private static final ElementDecoder<Object> charDecoder;
    private static final ElementDecoder<Character> javaCharacterDecoder;
    private static final ElementDecoder<Object> floatDecoder;
    private static final ElementDecoder<Float> javaFloatDecoder;
    private static final ElementDecoder<Object> doubleDecoder;
    private static final ElementDecoder<Double> javaDoubleDecoder;
    private static final ElementDecoder<Object> byteDecoder;
    private static final ElementDecoder<Byte> javaByteDecoder;
    private static final ElementDecoder<Object> shortDecoder;
    private static final ElementDecoder<Short> javaShortDecoder;
    private static final ElementDecoder<Object> intDecoder;
    private static final ElementDecoder<Integer> javaIntegerDecoder;
    private static final ElementDecoder<Object> longDecoder;
    private static final ElementDecoder<Long> javaLongDecoder;
    private static final ElementDecoder<BigInt> bigIntDecoder;
    private static final ElementDecoder<BigInteger> javaBigIntegerDecoder;
    private static final ElementDecoder<BigDecimal> bigDecimalDecoder;
    private static final ElementDecoder<java.math.BigDecimal> javaBigDecimalDecoder;
    private static final ElementDecoder<UUID> UUIDDecoder;
    private static final ElementDecoder<byte[]> base64Decoder;
    private static final ElementDecoder<None$> noneDecoder;
    private static final ElementDecoder<LocalDateTime> localDateTimeDecoder;
    private static final ElementDecoder<ZonedDateTime> zonedDateTimeDecoder;
    private static final ElementDecoder<OffsetDateTime> offsetDateTimeDecoder;
    private static final ElementDecoder<LocalDate> localDateDecoder;
    private static final ElementDecoder<LocalTime> localTimeDecoder;

    static {
        ElementLiteralInstances.$init$(MODULE$);
        stringDecoder = new ElementDecoder.StringDecoder(ElementDecoder$StringDecoder$.MODULE$.$lessinit$greater$default$1());
        unitDecoder = MODULE$.stringDecoder().map((Function1 & Serializable)x$1 -> {
            ElementDecoder$.$anonfun$unitDecoder$1(x$1);
            return BoxedUnit.UNIT;
        });
        booleanDecoder = MODULE$.stringDecoder().emap((Function2 & Serializable)(history, string) -> {
            String string2;
            block8: {
                block9: {
                    string2 = string;
                    switch (string2 == null ? 0 : string2.hashCode()) {
                        case 48: {
                            if (!"0".equals(string2)) break block8;
                            break block9;
                        }
                        case 49: {
                            if ("1".equals(string2)) {
                                break;
                            }
                            break block8;
                        }
                        case 3569038: {
                            if ("true".equals(string2)) {
                                break;
                            }
                            break block8;
                        }
                        case 97196323: {
                            if (!"false".equals(string2)) break block8;
                            break block9;
                        }
                        default: {
                            break block8;
                        }
                    }
                    return scala.package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToBoolean((boolean)true));
                }
                return scala.package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToBoolean((boolean)false));
            }
            return scala.package$.MODULE$.Left().apply((Object)new DecodingError(new StringBuilder(33).append("Value `").append(string2).append("` is not `true` or `false`").toString(), (List<String>)history));
        });
        javaBooleanDecoder = MODULE$.booleanDecoder().map((Function1 & Serializable)x$2 -> Predef$.MODULE$.boolean2Boolean(Predef$.MODULE$.boolean2Boolean(BoxesRunTime.unboxToBoolean((Object)x$2)).booleanValue()));
        charDecoder = MODULE$.stringDecoder().emap((Function2 & Serializable)(history, string) -> {
            if (string.length() != 1) {
                return scala.package$.MODULE$.Left().apply((Object)new DecodingError("Value too long for char", (List<String>)history));
            }
            return scala.package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToCharacter((char)StringOps$.MODULE$.head$extension(Predef$.MODULE$.augmentString(string))));
        });
        javaCharacterDecoder = MODULE$.charDecoder().map((Function1 & Serializable)x$3 -> Predef$.MODULE$.char2Character(Predef$.MODULE$.char2Character(BoxesRunTime.unboxToChar((Object)x$3)).charValue()));
        floatDecoder = MODULE$.stringDecoder().emap(package$.MODULE$.wrapException((Function1 & Serializable)x$4 -> BoxesRunTime.boxToFloat((float)StringOps$.MODULE$.toFloat$extension(Predef$.MODULE$.augmentString(x$4)))));
        javaFloatDecoder = MODULE$.floatDecoder().map((Function1 & Serializable)x$5 -> Predef$.MODULE$.float2Float(BoxesRunTime.unboxToFloat((Object)x$5)));
        doubleDecoder = MODULE$.stringDecoder().emap(package$.MODULE$.wrapException((Function1 & Serializable)x$6 -> BoxesRunTime.boxToDouble((double)StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(x$6)))));
        javaDoubleDecoder = MODULE$.doubleDecoder().map((Function1 & Serializable)x$7 -> Predef$.MODULE$.double2Double(BoxesRunTime.unboxToDouble((Object)x$7)));
        byteDecoder = MODULE$.stringDecoder().emap(package$.MODULE$.wrapException((Function1 & Serializable)x$8 -> BoxesRunTime.boxToByte((byte)StringOps$.MODULE$.toByte$extension(Predef$.MODULE$.augmentString(x$8)))));
        javaByteDecoder = MODULE$.byteDecoder().map((Function1 & Serializable)x$9 -> Predef$.MODULE$.byte2Byte(BoxesRunTime.unboxToByte((Object)x$9)));
        shortDecoder = MODULE$.stringDecoder().emap(package$.MODULE$.wrapException((Function1 & Serializable)x$10 -> BoxesRunTime.boxToShort((short)StringOps$.MODULE$.toShort$extension(Predef$.MODULE$.augmentString(x$10)))));
        javaShortDecoder = MODULE$.shortDecoder().map((Function1 & Serializable)x$11 -> Predef$.MODULE$.short2Short(BoxesRunTime.unboxToShort((Object)x$11)));
        intDecoder = MODULE$.stringDecoder().emap(package$.MODULE$.wrapException((Function1 & Serializable)x$12 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$12)))));
        javaIntegerDecoder = MODULE$.intDecoder().map((Function1 & Serializable)x$13 -> Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)x$13)));
        longDecoder = MODULE$.stringDecoder().emap(package$.MODULE$.wrapException((Function1 & Serializable)x$14 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$14)))));
        javaLongDecoder = MODULE$.longDecoder().map((Function1 & Serializable)x$15 -> Predef$.MODULE$.long2Long(BoxesRunTime.unboxToLong((Object)x$15)));
        bigIntDecoder = MODULE$.stringDecoder().emap(package$.MODULE$.wrapException((Function1 & Serializable)x -> scala.package$.MODULE$.BigInt().apply(x)));
        javaBigIntegerDecoder = MODULE$.stringDecoder().emap(package$.MODULE$.wrapException((Function1 & Serializable)str -> new BigInteger((String)str)));
        bigDecimalDecoder = MODULE$.stringDecoder().map((Function1 & Serializable)x -> scala.package$.MODULE$.BigDecimal().apply(x));
        javaBigDecimalDecoder = MODULE$.bigDecimalDecoder().map((Function1 & Serializable)x$16 -> x$16.bigDecimal());
        UUIDDecoder = MODULE$.stringDecoder().emap(package$.MODULE$.wrapException((Function1 & Serializable)x$1 -> UUID.fromString(x$1)));
        Base64.Decoder decoder = Base64.getDecoder();
        base64Decoder = MODULE$.stringDecoder().emap(package$.MODULE$.wrapException((Function1 & Serializable)x$1 -> decoder.decode((String)x$1)));
        noneDecoder = new ElementDecoder.ConstDecoder<None$>(None$.MODULE$);
        localDateTimeDecoder = MODULE$.stringDecoder().emap(package$.MODULE$.wrapException((Function1 & Serializable)x$1 -> LocalDateTime.parse(x$1)));
        zonedDateTimeDecoder = MODULE$.stringDecoder().emap(package$.MODULE$.wrapException((Function1 & Serializable)x$1 -> ZonedDateTime.parse(x$1)));
        offsetDateTimeDecoder = MODULE$.stringDecoder().emap(package$.MODULE$.wrapException((Function1 & Serializable)x$1 -> OffsetDateTime.parse(x$1)));
        localDateDecoder = MODULE$.stringDecoder().emap(package$.MODULE$.wrapException((Function1 & Serializable)x$1 -> LocalDate.parse(x$1)));
        localTimeDecoder = MODULE$.stringDecoder().emap(package$.MODULE$.wrapException((Function1 & Serializable)x$1 -> LocalTime.parse(x$1)));
    }

    @Override
    public <A, L extends A> ElementDecoder<L> literalDecoder(ElementDecoder<A> decoder, L valueOfL) {
        return ElementLiteralInstances.literalDecoder$(this, decoder, valueOfL);
    }

    public <A> ElementDecoder<A> apply(ElementDecoder<A> instance) {
        return instance;
    }

    public <A> Option<ElementDecoder.FailedDecoder<A>> errorIfWrongName(Cursor c, String localName, Option<String> namespaceUri) {
        Option<String> option = namespaceUri;
        String string = c.getLocalName();
        String string2 = localName;
        if (string == null ? string2 != null : !string.equals(string2)) {
            return new Some(new ElementDecoder.FailedDecoder(c.error(new StringBuilder(45).append("Invalid local name. Expected '").append(localName).append("', but found '").append(c.getLocalName()).append("'").toString())));
        }
        if (option instanceof Some) {
            String uri;
            Some some = (Some)option;
            String string3 = uri = (String)some.value();
            String string4 = c.getNamespaceURI();
            if (string3 == null ? string4 != null : !string3.equals(string4)) {
                return new Some(new ElementDecoder.FailedDecoder(c.error(new StringBuilder(44).append("Invalid namespace. Expected '").append(uri).append("', but found '").append(c.getNamespaceURI()).append("'").toString())));
            }
        }
        if (None$.MODULE$.equals(option)) {
            String string5 = c.getNamespaceURI();
            String string6 = "";
            if (string5 == null ? string6 != null : !string5.equals(string6)) {
                return new Some(new ElementDecoder.FailedDecoder(c.error(new StringBuilder(54).append("Invalid namespace. Expected no namespace, but found '").append(c.getNamespaceURI()).append("'").toString())));
            }
        }
        return None$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isNil(Cursor c) {
        int nilIdx = c.getAttributeIndex("http://www.w3.org/2001/XMLSchema-instance", "nil");
        if (nilIdx <= -1) return false;
        String string = c.getAttributeValue(nilIdx);
        String string2 = "true";
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    public DecodingError decodingNotCompleteError(List<String> history) {
        List<String> list = history;
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            String element = (String)colon2.head();
            List others = colon2.next$access$1();
            return new DecodingError(new StringBuilder(32).append("Element '").append(element).append("' is missing or invalid").toString(), (List<String>)others);
        }
        if (Nil$.MODULE$.equals(list)) {
            return new DecodingError("Root element is missing or invalid", (List<String>)Nil$.MODULE$);
        }
        throw new MatchError(list);
    }

    public ElementDecoder<String> stringDecoder() {
        return stringDecoder;
    }

    public ElementDecoder<BoxedUnit> unitDecoder() {
        return unitDecoder;
    }

    public ElementDecoder<Object> booleanDecoder() {
        return booleanDecoder;
    }

    public ElementDecoder<Boolean> javaBooleanDecoder() {
        return javaBooleanDecoder;
    }

    public ElementDecoder<Object> charDecoder() {
        return charDecoder;
    }

    public ElementDecoder<Character> javaCharacterDecoder() {
        return javaCharacterDecoder;
    }

    public ElementDecoder<Object> floatDecoder() {
        return floatDecoder;
    }

    public ElementDecoder<Float> javaFloatDecoder() {
        return javaFloatDecoder;
    }

    public ElementDecoder<Object> doubleDecoder() {
        return doubleDecoder;
    }

    public ElementDecoder<Double> javaDoubleDecoder() {
        return javaDoubleDecoder;
    }

    public ElementDecoder<Object> byteDecoder() {
        return byteDecoder;
    }

    public ElementDecoder<Byte> javaByteDecoder() {
        return javaByteDecoder;
    }

    public ElementDecoder<Object> shortDecoder() {
        return shortDecoder;
    }

    public ElementDecoder<Short> javaShortDecoder() {
        return javaShortDecoder;
    }

    public ElementDecoder<Object> intDecoder() {
        return intDecoder;
    }

    public ElementDecoder<Integer> javaIntegerDecoder() {
        return javaIntegerDecoder;
    }

    public ElementDecoder<Object> longDecoder() {
        return longDecoder;
    }

    public ElementDecoder<Long> javaLongDecoder() {
        return javaLongDecoder;
    }

    public ElementDecoder<BigInt> bigIntDecoder() {
        return bigIntDecoder;
    }

    public ElementDecoder<BigInteger> javaBigIntegerDecoder() {
        return javaBigIntegerDecoder;
    }

    public ElementDecoder<BigDecimal> bigDecimalDecoder() {
        return bigDecimalDecoder;
    }

    public ElementDecoder<java.math.BigDecimal> javaBigDecimalDecoder() {
        return javaBigDecimalDecoder;
    }

    public ElementDecoder<UUID> UUIDDecoder() {
        return UUIDDecoder;
    }

    public ElementDecoder<byte[]> base64Decoder() {
        return base64Decoder;
    }

    public <A> ElementDecoder<Option<A>> optionDecoder(ElementDecoder<A> decoder) {
        return new ElementDecoder<Option<A>>(decoder){
            private final boolean isCompleted;
            private final ElementDecoder decoder$1;

            public <B$> ElementDecoder<B$> map(Function1<Option<A>, B$> f) {
                return ElementDecoder.map$(this, f);
            }

            public <B$> ElementDecoder<B$> emap(Function2<List<String>, Option<A>, Either<DecodingError, B$>> f) {
                return ElementDecoder.emap$(this, f);
            }

            public ElementDecoder<Option<A>> decodeAsElement(Cursor c, String localName, Option<String> namespaceUri) {
                if (c.isStartElement()) {
                    return (ElementDecoder)ElementDecoder$.MODULE$.errorIfWrongName(c, localName, namespaceUri).getOrElse((Function0 & Serializable)() -> {
                        if (ElementDecoder$.MODULE$.isNil(c)) {
                            c.next();
                            return new ElementDecoder.ConstDecoder<None$>(None$.MODULE$);
                        }
                        return $this.decoder$1.map((Function1 & Serializable)a -> new Some(a)).decodeAsElement(c, localName, namespaceUri);
                    });
                }
                return new ElementDecoder.FailedDecoder<Option<A>>(c.error(new StringBuilder(20).append("Unexpected event: '").append(c.getEventType()).append("'").toString()));
            }

            public Either<DecodingError, Option<A>> result(Function0<List<String>> history) {
                return scala.package$.MODULE$.Right().apply((Object)None$.MODULE$);
            }

            public boolean isCompleted() {
                return this.isCompleted;
            }
            {
                this.decoder$1 = decoder$1;
                ElementDecoder.$init$(this);
                this.isCompleted = true;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$decodeAsElement$3(ru.tinkoff.phobos.decoding.ElementDecoder$$anon$1 ru.tinkoff.phobos.decoding.Cursor java.lang.String scala.Option ), $anonfun$decodeAsElement$4(java.lang.Object )}, serializedLambda);
            }
        };
    }

    public <A> ElementDecoder<Some<A>> someDecoder(ElementDecoder<A> e) {
        return e.map((Function1 & Serializable)value -> new Some(value));
    }

    public ElementDecoder<None$> noneDecoder() {
        return noneDecoder;
    }

    public <A> ElementDecoder<List<A>> listDecoder(ElementDecoder<A> decoder) {
        return new ElementDecoder.ListDecoder<A>(ElementDecoder$ListDecoder$.MODULE$.$lessinit$greater$default$1(), ElementDecoder$ListDecoder$.MODULE$.$lessinit$greater$default$2(), decoder);
    }

    public <A> ElementDecoder<Seq<A>> seqDecoder(ElementDecoder<A> decoder) {
        return this.listDecoder(decoder).map((Function1 & Serializable)x$17 -> (List)x$17.toSeq());
    }

    public <A> ElementDecoder<Set<A>> setDecoder(ElementDecoder<A> decoder) {
        return this.listDecoder(decoder).map((Function1 & Serializable)x$18 -> x$18.toSet());
    }

    public <A> ElementDecoder<Vector<A>> vectorDecoder(ElementDecoder<A> decoder) {
        return this.listDecoder(decoder).map((Function1 & Serializable)x$19 -> x$19.toVector());
    }

    public ElementDecoder<LocalDateTime> localDateTimeDecoder() {
        return localDateTimeDecoder;
    }

    public ElementDecoder<LocalDateTime> localDateTimeDecoderWithFormatter(DateTimeFormatter formatter) {
        return this.stringDecoder().emap(package$.MODULE$.wrapException((Function1 & Serializable)x$20 -> LocalDateTime.parse(x$20, formatter)));
    }

    public ElementDecoder<ZonedDateTime> zonedDateTimeDecoder() {
        return zonedDateTimeDecoder;
    }

    public ElementDecoder<ZonedDateTime> zonedDateTimeDecoderWithFormatter(DateTimeFormatter formatter) {
        return this.stringDecoder().emap(package$.MODULE$.wrapException((Function1 & Serializable)x$21 -> ZonedDateTime.parse(x$21, formatter)));
    }

    public ElementDecoder<OffsetDateTime> offsetDateTimeDecoder() {
        return offsetDateTimeDecoder;
    }

    public ElementDecoder<OffsetDateTime> offsetDateTimeDecoderWithFormatter(DateTimeFormatter formatter) {
        return this.stringDecoder().emap(package$.MODULE$.wrapException((Function1 & Serializable)x$22 -> OffsetDateTime.parse(x$22, formatter)));
    }

    public ElementDecoder<LocalDate> localDateDecoder() {
        return localDateDecoder;
    }

    public ElementDecoder<LocalDate> localDateDecoderWithFormatter(DateTimeFormatter formatter) {
        return this.stringDecoder().emap(package$.MODULE$.wrapException((Function1 & Serializable)x$23 -> LocalDate.parse(x$23, formatter)));
    }

    public ElementDecoder<LocalTime> localTimeDecoder() {
        return localTimeDecoder;
    }

    public ElementDecoder<LocalTime> localTimeDecoderWithFormatter(DateTimeFormatter formatter) {
        return this.stringDecoder().emap(package$.MODULE$.wrapException((Function1 & Serializable)x$24 -> LocalTime.parse(x$24, formatter)));
    }

    public static final /* synthetic */ void $anonfun$unitDecoder$1(String x$1) {
    }

    private ElementDecoder$() {
    }
}

