/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.jmib.generator;

import com.google.common.collect.Lists;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;
import se.bjurr.jmib.anotations.BuilderStyle;
import se.bjurr.jmib.model.ClassMethod;
import se.bjurr.jmib.model.ClassMethodParameter;

public class CodeGenerator {
    public JavaFile generateJavaFile(String packageName, String classToInvoke, String newClassName, ClassMethod classMethod, BuilderStyle builderStyle) {
        ClassName instanceClassName = ClassName.get((String)packageName, (String)classToInvoke, (String[])new String[0]);
        ParameterSpec instanceParameter = ParameterSpec.builder((TypeName)instanceClassName, (String)"instance", (Modifier[])new Modifier[]{Modifier.FINAL}).build();
        MethodSpec.Builder constructor = this.getConstructor(builderStyle, instanceParameter);
        this.setDefaltParameters(classMethod.getParameters(), constructor);
        TypeSpec.Builder javaFile = TypeSpec.classBuilder((String)newClassName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addTypeVariables(classMethod.getTypeParameters().toTypeVariableNameList()).addMethod(constructor.build());
        ClassName selfWithoutGenericTypeArguments = ClassName.get((String)packageName, (String)newClassName, (String[])new String[0]);
        Object self = classMethod.getTypeParameters().isEmpty() ? selfWithoutGenericTypeArguments : ParameterizedTypeName.get((ClassName)selfWithoutGenericTypeArguments, (TypeName[])classMethod.getTypeParameters().toTypeNameArray());
        this.addParameters(classMethod, javaFile, (TypeName)self);
        if (builderStyle == BuilderStyle.SUPPLY_INSTANCE_WITH_ON_METHOD || builderStyle == BuilderStyle.SUPPLY_INSTANCE_IN_CONSTRUCTOR) {
            javaFile.addField((TypeName)instanceClassName, "instance", new Modifier[]{Modifier.PRIVATE});
        }
        if (builderStyle == BuilderStyle.SUPPLY_INSTANCE_WITH_ON_METHOD) {
            this.addOnMethod(instanceParameter, javaFile, (TypeName)self);
        }
        Iterable<MethodSpec> invokeMethodSpec = this.getInvokeMethod(packageName, classToInvoke, classMethod, builderStyle);
        MethodSpec staticConstructorMethod = this.getStaticConstructorMethod(newClassName, classMethod, (TypeName)self, builderStyle, instanceParameter);
        TypeSpec typeSpec = javaFile.addMethod(staticConstructorMethod).addMethods(invokeMethodSpec).build();
        return JavaFile.builder((String)packageName, (TypeSpec)typeSpec).build();
    }

    private MethodSpec getStaticConstructorMethod(String newClassName, ClassMethod classMethod, TypeName self, BuilderStyle builderStyle, ParameterSpec instanceParameter) {
        String instantiation;
        String string = instantiation = classMethod.getTypeParameters().isEmpty() ? "new " + newClassName : "new " + newClassName + "<>";
        if (builderStyle == BuilderStyle.SUPPLY_INSTANCE_IN_CONSTRUCTOR) {
            return MethodSpec.methodBuilder((String)classMethod.getName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addTypeVariables(classMethod.getTypeParameters().toTypeVariableNameList()).addParameter(instanceParameter).addStatement("return " + instantiation + "(instance)", new Object[0]).returns(self).build();
        }
        return MethodSpec.methodBuilder((String)classMethod.getName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addTypeVariables(classMethod.getTypeParameters().toTypeVariableNameList()).addStatement("return " + instantiation + "()", new Object[0]).returns(self).build();
    }

    private void addOnMethod(ParameterSpec instanceParameter, TypeSpec.Builder javaFile, TypeName self) {
        MethodSpec onMethod = MethodSpec.methodBuilder((String)"on").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(instanceParameter).addStatement("this.instance = instance", new Object[0]).addStatement("return this", new Object[0]).returns(self).build();
        javaFile.addMethod(onMethod);
    }

    private void addParameters(ClassMethod classMethod, TypeSpec.Builder javaFile, TypeName self) {
        for (ClassMethodParameter classMethodParameter : classMethod.getParameters()) {
            TypeName fieldType = TypeName.get((TypeMirror)classMethodParameter.getType());
            String fieldName = classMethodParameter.getName();
            javaFile.addField(fieldType, fieldName, new Modifier[]{Modifier.PRIVATE}).addMethod(MethodSpec.methodBuilder((String)("with" + this.ucFirst(fieldName))).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)fieldType, (String)fieldName, (Modifier[])new Modifier[]{Modifier.FINAL}).build()).addStatement("this." + fieldName + " = " + fieldName, new Object[0]).addStatement("return this", new Object[0]).returns(self).build());
        }
    }

    private void setDefaltParameters(List<ClassMethodParameter> classMethodParameters, MethodSpec.Builder constructor) {
        for (ClassMethodParameter classMethodParameter : classMethodParameters) {
            if (!classMethodParameter.getDefaultValue().isPresent()) continue;
            constructor.addStatement("this." + classMethodParameter.getName() + " = " + (String)classMethodParameter.getDefaultValue().get(), new Object[0]);
        }
    }

    private MethodSpec.Builder getConstructor(BuilderStyle builderStyle, ParameterSpec instanceParameter) {
        if (builderStyle == BuilderStyle.SUPPLY_INSTANCE_IN_CONSTRUCTOR) {
            return MethodSpec.constructorBuilder().addParameter(instanceParameter).beginControlFlow("if (instance == null)", new Object[0]).addStatement("throw new java.lang.IllegalStateException(\"You must supply an instance.\")", new Object[0]).endControlFlow().addStatement("this.instance = instance", new Object[0]).addModifiers(new Modifier[]{Modifier.PRIVATE});
        }
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE});
    }

    private Iterable<MethodSpec> getInvokeMethod(String packageName, String classToInvoke, ClassMethod classMethod, BuilderStyle builderStyle) {
        TypeName returns = TypeName.get((TypeMirror)classMethod.getReturnType());
        boolean shouldReturn = !returns.equals((Object)TypeName.VOID);
        String callStatementArguments = classMethod.getName() + "(" + this.parameters(classMethod.getParameters()) + ")";
        String callStatementParameter = "instance." + callStatementArguments;
        String callStatementAttribute = "this.instance." + callStatementArguments;
        if (shouldReturn) {
            callStatementParameter = "return " + callStatementParameter;
            callStatementAttribute = "return " + callStatementAttribute;
        }
        ArrayList methods = Lists.newArrayList();
        if (builderStyle == BuilderStyle.SUPPLY_INSTANCE_WITH_ON_METHOD || builderStyle == BuilderStyle.SUPPLY_INSTANCE_IN_CONSTRUCTOR) {
            methods.add(MethodSpec.methodBuilder((String)"invoke").addModifiers(new Modifier[]{Modifier.PUBLIC}).beginControlFlow("if (this.instance == null)", new Object[0]).addStatement("throw new java.lang.IllegalStateException(\"You must supply an instance to the builder!\")", new Object[0]).endControlFlow().addStatement(callStatementAttribute, new Object[0]).returns(returns).build());
        }
        if (builderStyle == BuilderStyle.SUPPLY_INSTANCE_AS_INVOKE_PARAMETER) {
            methods.add(MethodSpec.methodBuilder((String)"invoke").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)ClassName.get((String)packageName, (String)classToInvoke, (String[])new String[0]), (String)"instance", (Modifier[])new Modifier[]{Modifier.FINAL}).build()).addStatement(callStatementParameter, new Object[0]).returns(returns).build());
        }
        if (methods.isEmpty()) {
            throw new RuntimeException("Could not create invoke method.");
        }
        return methods;
    }

    private String parameters(List<ClassMethodParameter> parameters) {
        StringBuilder sb = new StringBuilder();
        for (ClassMethodParameter p : parameters) {
            if (parameters.indexOf(p) == 0) {
                sb.append(p.getName());
                continue;
            }
            sb.append("," + p.getName());
        }
        return sb.toString();
    }

    private String ucFirst(String s) {
        return s.substring(0, 1).toUpperCase(Locale.US) + s.substring(1);
    }
}

