/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.jmib.processor;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.squareup.javapoet.JavaFile;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import se.bjurr.jmib.anotations.BuilderStyle;
import se.bjurr.jmib.anotations.Default;
import se.bjurr.jmib.anotations.GenerateMethodInvocationBuilder;
import se.bjurr.jmib.generator.CodeGenerator;
import se.bjurr.jmib.model.ClassMethod;
import se.bjurr.jmib.model.ClassMethodParameter;
import se.bjurr.jmib.model.ClassMethodTypeParameterList;
import se.bjurr.jmib.model.ClassModel;

public class ElementHandler {
    private final Elements elementUtils;
    private final Filer filer;
    private final Messager messager;

    public ElementHandler(Elements elementUtils, Filer filer, Messager messager) {
        this.elementUtils = elementUtils;
        this.filer = filer;
        this.messager = messager;
    }

    public void handle(TypeElement classElement) throws IOException {
        String packageName = this.getPackageName(classElement);
        String classFullyQualified = this.getClassFullyQualified(classElement);
        GenerateMethodInvocationBuilder generateMethodInvocationBuilder = classElement.getAnnotation(GenerateMethodInvocationBuilder.class);
        BuilderStyle builderStyle = generateMethodInvocationBuilder.style();
        if (builderStyle == null) {
            builderStyle = BuilderStyle.SUPPLY_INSTANCE_AS_INVOKE_PARAMETER;
        }
        List<ClassMethod> methods = this.findMethods(classElement);
        ClassModel classModel = new ClassModel(packageName, classFullyQualified, methods);
        this.writeResults(classElement, classModel, builderStyle);
    }

    private List<ClassMethod> findMethods(TypeElement classElement) {
        ArrayList methods = Lists.newArrayList();
        List<? extends Element> allMembers = this.elementUtils.getAllMembers(classElement);
        for (Element element : allMembers) {
            if (element.getKind() != ElementKind.METHOD || element.getModifiers().contains((Object)Modifier.PRIVATE) || this.objectHasMethod(element.getSimpleName().toString())) continue;
            methods.add(this.handle((ExecutableElement)element));
        }
        return methods;
    }

    private String getClassFullyQualified(TypeElement classElement) {
        return classElement.getQualifiedName().toString();
    }

    private Optional<String> getDefaultValue(VariableElement parameter) {
        Default defaultAnnotation = parameter.getAnnotation(Default.class);
        if (defaultAnnotation == null) {
            return Optional.absent();
        }
        String defaultValue = defaultAnnotation.value();
        if (parameter.asType().toString().equals(String.class.getName())) {
            defaultValue = "\"" + defaultAnnotation.value() + "\"";
        }
        return Optional.of((Object)defaultValue);
    }

    private String getPackageName(Element element) {
        PackageElement packageElement = this.elementUtils.getPackageOf(element);
        return packageElement.getQualifiedName().toString();
    }

    private ClassMethod handle(ExecutableElement member) {
        ClassMethodTypeParameterList typeParameters = ClassMethodTypeParameterList.newInstance(member.getTypeParameters());
        ArrayList parameters = Lists.newArrayList();
        TypeMirror returnType = member.getReturnType();
        String methodName = member.getSimpleName().toString();
        for (VariableElement variableElement : member.getParameters()) {
            TypeMirror type = variableElement.asType();
            String name = variableElement.getSimpleName().toString();
            Optional<String> defaultValue = this.getDefaultValue(variableElement);
            parameters.add(new ClassMethodParameter(type, name, (String)defaultValue.orNull()));
        }
        return new ClassMethod(methodName, returnType, parameters, typeParameters);
    }

    private boolean objectHasMethod(String name) {
        Method[] objectMethods;
        for (Method m : objectMethods = Object.class.getDeclaredMethods()) {
            if (!m.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private String ucFirst(String s) {
        return s.substring(0, 1).toUpperCase(Locale.US) + s.substring(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeResults(TypeElement classElement, ClassModel classModel, BuilderStyle builderStyle) throws IOException {
        for (ClassMethod classMethod : classModel.getMethods()) {
            String classNameSuffix = this.ucFirst(classMethod.getName()) + "Builder";
            String newClassName = classModel.getClassFullyQualifiedName() + classNameSuffix;
            JavaFileObject newJavaFileObject = this.filer.createSourceFile(newClassName, classElement);
            JavaFile javaFile = new CodeGenerator().generateJavaFile(classModel.getPackageName(), classModel.getClassName(), classModel.getClassName() + classNameSuffix, classMethod, builderStyle);
            try (Writer writer = newJavaFileObject.openWriter();){
                javaFile.writeTo((Appendable)writer);
            }
            this.messager.printMessage(Diagnostic.Kind.NOTE, "Created: " + newJavaFileObject.toUri() + "\nPackage: " + classModel.getPackageName() + "\nClass: " + newClassName);
        }
    }
}

