/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.springresttemplateclient.handler;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.URI;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;
import se.bjurr.springresttemplateclient.parse.InvocationParser;
import se.bjurr.springresttemplateclient.parse.model.InvocationDetails;

public class SpringRestTemplateClientInvocationHandler<T>
implements InvocationHandler {
    private final String url;
    private final RestTemplate restTemplate;

    public SpringRestTemplateClientInvocationHandler(String url, RestTemplate restTemplate, HttpHeaders headers) {
        this.url = url;
        this.restTemplate = restTemplate;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        InvocationDetails invocationDetails = InvocationParser.getInvocationDetails(proxy, method, args);
        return this.doRequest(invocationDetails);
    }

    private Object doRequest(InvocationDetails invocationDetails) {
        URI uri = UriComponentsBuilder.fromHttpUrl((String)this.url).path(invocationDetails.getRequestDetails().getRequestPath()).queryParams(invocationDetails.getQueryParams()).build(invocationDetails.getPathVariables());
        RequestEntity.BodyBuilder bodyBuilder = RequestEntity.method((HttpMethod)invocationDetails.getRequestDetails().getRequestMethod(), (URI)uri);
        bodyBuilder.headers(invocationDetails.getHeaders());
        if (invocationDetails.getRequestDetails().findConsumes().isPresent()) {
            bodyBuilder.contentType(invocationDetails.getRequestDetails().findConsumes().get());
        }
        if (invocationDetails.getRequestDetails().findProduces().isPresent()) {
            bodyBuilder.accept(new MediaType[]{invocationDetails.getRequestDetails().findProduces().get()});
        }
        RequestEntity requestEntity = invocationDetails.findRequestBody().isPresent() ? bodyBuilder.body(invocationDetails.findRequestBody().get()) : bodyBuilder.build();
        if (invocationDetails.isMethodReurnTypeResponseEntity()) {
            return this.restTemplate.exchange(requestEntity, invocationDetails.getResponseType());
        }
        return this.restTemplate.exchange(requestEntity, invocationDetails.getResponseType()).getBody();
    }
}

