/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.springresttemplateclient.parse;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.ResolvableType;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import se.bjurr.springresttemplateclient.parse.RequestMappingParser;
import se.bjurr.springresttemplateclient.parse.model.InvocationDetails;
import se.bjurr.springresttemplateclient.parse.model.RequestDetails;

public final class InvocationParser {
    private InvocationParser() {
    }

    public static RequestMethod getRequestMethod(Method method) {
        if (InvocationParser.findAnnotation(method, GetMapping.class).isPresent()) {
            return RequestMethod.GET;
        }
        if (InvocationParser.findAnnotation(method, PostMapping.class).isPresent()) {
            return RequestMethod.POST;
        }
        if (InvocationParser.findAnnotation(method, PutMapping.class).isPresent()) {
            return RequestMethod.PUT;
        }
        if (InvocationParser.findAnnotation(method, DeleteMapping.class).isPresent()) {
            return RequestMethod.DELETE;
        }
        if (InvocationParser.findAnnotation(method, PatchMapping.class).isPresent()) {
            return RequestMethod.PATCH;
        }
        Optional<RequestMapping> requestMapping = InvocationParser.findAnnotation(method, RequestMapping.class);
        if (requestMapping.isPresent()) {
            return requestMapping.get().method()[0];
        }
        throw new RuntimeException("Cannot find request method of " + method.getName());
    }

    public static <T> Optional<T> findAnnotation(Method method, Class<T> findAnnotation) {
        Annotation[] methodAnnotations = method.getAnnotations();
        return InvocationParser.findAnnotation(methodAnnotations, findAnnotation);
    }

    private static <T> Optional<T> findAnnotation(Annotation[] methodAnnotations, Class<T> annotations) {
        for (Annotation annotation : methodAnnotations) {
            if (annotation.annotationType() != annotations) continue;
            return Optional.of(annotation);
        }
        return Optional.empty();
    }

    public static <T> T getAnnotation(Method method, Class<T> clazz, String message) {
        Optional<T> requestMapping = InvocationParser.findAnnotation(method, clazz);
        if (!requestMapping.isPresent()) {
            throw new RuntimeException(message);
        }
        return requestMapping.get();
    }

    public static Map<String, String> getPathVariables(Method method, Object[] args) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < method.getParameterCount(); ++i) {
            Parameter p = method.getParameters()[i];
            PathVariable pv = p.getAnnotation(PathVariable.class);
            if (pv == null) continue;
            map.put(pv.value(), args[i].toString());
        }
        return map;
    }

    public static MultiValueMap<String, String> getRequestVariables(Method method, Object[] args) {
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        for (int i = 0; i < method.getParameterCount(); ++i) {
            Object[] arr;
            Parameter p = method.getParameters()[i];
            RequestParam rp = p.getAnnotation(RequestParam.class);
            if (rp == null) continue;
            Object arg = args[i];
            if (arg instanceof List) {
                arr = (Object[])arg;
                for (Object e : arr) {
                    map.add((Object)rp.value(), (Object)e.toString());
                }
                continue;
            }
            if (arg.getClass().isArray()) {
                for (Object element : arr = (Object[])arg) {
                    map.add((Object)rp.value(), (Object)element.toString());
                }
                continue;
            }
            map.add((Object)rp.value(), (Object)args[i].toString());
        }
        return map;
    }

    private static MultiValueMap<String, String> getHeaderVariables(Method method, Object[] args) {
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        for (int i = 0; i < method.getParameterCount(); ++i) {
            Parameter p = method.getParameters()[i];
            RequestHeader rh = p.getAnnotation(RequestHeader.class);
            if (rh == null) continue;
            map.add((Object)rh.value(), (Object)args[i].toString());
        }
        return map;
    }

    public static Optional<Object> findReqestBody(Method method, Object[] args) {
        for (int i = 0; i < method.getParameterCount(); ++i) {
            Parameter p = method.getParameters()[i];
            RequestBody rb = p.getAnnotation(RequestBody.class);
            if (rb == null) continue;
            return Optional.of(args[i]);
        }
        return Optional.empty();
    }

    public static Type getGenericTypeOfMethod(Object proxy, Method method) {
        ResolvableType r = ResolvableType.forMethodReturnType((Method)method);
        return r.getGeneric(new int[]{0}).getType();
    }

    public static InvocationDetails getInvocationDetails(final Object proxy, final Method method, Object[] args) throws ClassNotFoundException {
        RequestDetails requestDetails = InvocationParser.getRequestDetails(method);
        MultiValueMap<String, String> queryParams = InvocationParser.getRequestVariables(method, args);
        Map<String, String> pathVariables = InvocationParser.getPathVariables(method, args);
        Optional<Object> requestBody = InvocationParser.findReqestBody(method, args);
        boolean methodReurnTypeIsResponseEntity = method.getReturnType().isAssignableFrom(ResponseEntity.class);
        ParameterizedTypeReference<Type> responseType = null;
        responseType = methodReurnTypeIsResponseEntity ? new ParameterizedTypeReference<Type>(){

            public Type getType() {
                return InvocationParser.getGenericTypeOfMethod(proxy, method);
            }
        } : new ParameterizedTypeReference<Type>(){

            public Type getType() {
                return method.getGenericReturnType();
            }
        };
        HttpHeaders headers = requestDetails.getHttpHeaders();
        MultiValueMap<String, String> headerParams = InvocationParser.getHeaderVariables(method, args);
        for (Map.Entry header : headerParams.entrySet()) {
            for (String value : (List)header.getValue()) {
                headers.add((String)header.getKey(), value);
            }
        }
        return new InvocationDetails(requestDetails, queryParams, pathVariables, requestBody.orElse(null), methodReurnTypeIsResponseEntity, responseType, headers);
    }

    private static RequestDetails getRequestDetails(Method method) {
        Optional<RequestMapping> requestMapping = InvocationParser.findAnnotation(method, RequestMapping.class);
        if (requestMapping.isPresent()) {
            return RequestMappingParser.getRequestDetails(requestMapping.get());
        }
        throw new RuntimeException("Only RequestMapping is, currently, implemented. PR:s are welcome.");
    }
}

