/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.springresttemplateclient.parse;

import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import se.bjurr.springresttemplateclient.parse.model.RequestDetails;

public class RequestMappingParser {
    public static RequestDetails getRequestDetails(RequestMapping requestMapping) {
        if (requestMapping.method().length != 1) {
            throw new RuntimeException("Only one request method, currently, supported. PR:s are welcome.");
        }
        HttpMethod requestMethod = HttpMethod.valueOf((String)requestMapping.method()[0].name());
        if (requestMapping.value().length != 1) {
            throw new RuntimeException("Only one request path, currently, supported. PR:s are welcome.");
        }
        String requestPath = requestMapping.value()[0];
        if (requestMapping.consumes().length > 1) {
            throw new RuntimeException("Only one, or zero, consumes, currently, supported. PR:s are welcome.");
        }
        MediaType consumes = null;
        if (requestMapping.consumes().length == 1) {
            String consumesString = requestMapping.consumes()[0];
            consumes = MediaType.parseMediaType((String)consumesString);
        }
        if (requestMapping.produces().length > 1) {
            throw new RuntimeException("Only one, or zero, produces, currently, supported. PR:s are welcome.");
        }
        MediaType produces = null;
        if (requestMapping.produces().length == 1) {
            String producesString = requestMapping.produces()[0];
            produces = MediaType.parseMediaType((String)producesString);
        }
        HttpHeaders httpHeaders = new HttpHeaders();
        for (String header : requestMapping.headers()) {
            int equalityIndex = header.indexOf("=");
            if (equalityIndex == -1) {
                throw new RuntimeException("Cannot parse header '" + header + "'");
            }
            String[] spitted = header.split("=");
            httpHeaders.add(spitted[0], spitted[1]);
        }
        return new RequestDetails(requestMethod, requestPath, consumes, produces, httpHeaders);
    }
}

