/*
 * Decompiled with CFR 0.152.
 */
package se.fnord.logtags.log4j2_logstash.layout;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.StringLayout;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.layout.AbstractLayout;
import org.apache.logging.log4j.core.layout.ByteBufferDestination;
import org.apache.logging.log4j.core.layout.StringBuilderEncoder;
import org.apache.logging.log4j.core.net.Severity;
import org.apache.logging.log4j.core.pattern.DatePatternConverter;
import org.apache.logging.log4j.core.pattern.NameAbbreviator;
import org.apache.logging.log4j.core.util.JsonUtils;
import org.apache.logging.log4j.core.util.NetUtils;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.util.StringBuilderFormattable;
import org.apache.logging.log4j.util.StringBuilders;
import se.fnord.logtags.log4j2_logstash.layout.StacktraceFormat;
import se.fnord.logtags.log4j2_logstash.taggedmessage.TaggedMessage;
import se.fnord.logtags.tags.TagConsumer;

@Plugin(name="LogstashLayoutV1", category="Core", elementType="layout")
public class LogstashLayoutV1
extends AbstractLayout<String>
implements StringLayout,
TagConsumer<StringBuilder> {
    private static final char C = ',';
    private static final char Q = '\"';
    private static final String QC = "\",";
    private static final String CQ = ",\"";
    private static final String CQU = ",\"_";
    private static final int DEFAULT_STRING_BUILDER_SIZE = 1024;
    private static final int MAX_STRING_BUILDER_SIZE = Math.max(1024, Integer.getInteger("log4j.layoutStringBuilder.maxSize", 2048));
    private static final ThreadLocal<StringBuilder[]> stringBuilders = ThreadLocal.withInitial(() -> new StringBuilder[]{new StringBuilder(1024), new StringBuilder(1024)});
    private static DatePatternConverter DATE_FORMATTER = DatePatternConverter.newInstance((String[])new String[]{"ISO8601_PERIOD", "UTC"});
    private final boolean includeStacktrace;
    private final boolean includeThreadContext;
    private final boolean includeTimestamp;
    private final boolean includeNullTags;
    private final String objectHeader;
    private final StacktraceFormat stacktraceFormat;
    private final StringBuilderEncoder encoder;

    private LogstashLayoutV1(Configuration config, String host, boolean includeStacktrace, boolean includeThreadContext, boolean includeTimestamp, boolean includeNullTags, StacktraceFormat stacktraceFormat) {
        super(config, null, null);
        this.objectHeader = LogstashLayoutV1.renderObjectHeader(1, host);
        this.includeStacktrace = includeStacktrace;
        this.includeThreadContext = includeThreadContext;
        this.includeTimestamp = includeTimestamp;
        this.includeNullTags = includeNullTags;
        this.stacktraceFormat = stacktraceFormat;
        this.encoder = new StringBuilderEncoder(StandardCharsets.UTF_8);
    }

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Object)((Builder)new Builder().asBuilder()));
    }

    public Map<String, String> getContentFormat() {
        return Collections.emptyMap();
    }

    public String getContentType() {
        return "application/json";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T transformEvent(LogEvent event, EventTransformer<T> transformer) {
        StringBuilder[] builders = stringBuilders.get();
        builders[0].setLength(0);
        builders[1].setLength(0);
        try {
            T t = transformer.transform(event, builders[0], builders[1]);
            return t;
        }
        finally {
            StringBuilders.trimToMaxSize((StringBuilder)builders[0], (int)MAX_STRING_BUILDER_SIZE);
            StringBuilders.trimToMaxSize((StringBuilder)builders[1], (int)MAX_STRING_BUILDER_SIZE);
        }
    }

    public Charset getCharset() {
        return StandardCharsets.UTF_8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> void transformEvent(LogEvent event, T into, EventTransformerTo<T> transformer) {
        StringBuilder[] builders = stringBuilders.get();
        builders[0].setLength(0);
        builders[1].setLength(0);
        try {
            transformer.transformTo(event, into, builders[0], builders[1]);
        }
        finally {
            StringBuilders.trimToMaxSize((StringBuilder)builders[0], (int)MAX_STRING_BUILDER_SIZE);
            StringBuilders.trimToMaxSize((StringBuilder)builders[1], (int)MAX_STRING_BUILDER_SIZE);
        }
    }

    private byte[] toByteArray(LogEvent event, StringBuilder textBuilder, StringBuilder jsonBuilder) {
        this.toText(event, textBuilder, jsonBuilder);
        return jsonBuilder.toString().getBytes(StandardCharsets.UTF_8);
    }

    public byte[] toByteArray(LogEvent event) {
        return LogstashLayoutV1.transformEvent(event, this::toByteArray);
    }

    private void encode(LogEvent event, ByteBufferDestination destination, StringBuilder textBuilder, StringBuilder jsonBuilder) {
        this.toText(event, textBuilder, jsonBuilder);
        this.encoder.encode(jsonBuilder, destination);
    }

    public void encode(LogEvent event, ByteBufferDestination destination) {
        LogstashLayoutV1.transformEvent(event, destination, this::encode);
    }

    private String toSerializable(LogEvent event, StringBuilder textBuilder, StringBuilder jsonBuilder) {
        this.toText(event, textBuilder, jsonBuilder);
        return jsonBuilder.toString();
    }

    public String toSerializable(LogEvent event) {
        return LogstashLayoutV1.transformEvent(event, this::toSerializable);
    }

    private static String renderObjectHeader(int version, String host) {
        StringBuilder builder = new StringBuilder();
        LogstashLayoutV1.appendVersionField(version, builder);
        LogstashLayoutV1.appendHostField(host, builder);
        return builder.toString();
    }

    private void toText(LogEvent event, StringBuilder textBuilder, StringBuilder jsonBuilder) {
        Message message;
        jsonBuilder.append('{');
        jsonBuilder.append(this.objectHeader);
        if (this.includeTimestamp) {
            jsonBuilder.append("\"@timestamp\":\"");
            LogstashLayoutV1.appendTimestamp(event.getTimeMillis(), jsonBuilder).append(QC);
        }
        jsonBuilder.append("\"level\":\"").append(event.getLevel().name()).append(QC);
        jsonBuilder.append("\"level_value\":");
        LogstashLayoutV1.appendLevelValue(event.getLevel(), jsonBuilder);
        if (event.getThreadName() != null) {
            jsonBuilder.append(",\"thread_name\":\"");
            JsonUtils.quoteAsString((CharSequence)event.getThreadName(), (StringBuilder)jsonBuilder);
            jsonBuilder.append('\"');
        }
        if (event.getLoggerName() != null) {
            jsonBuilder.append(",\"logger_name\":\"");
            JsonUtils.quoteAsString((CharSequence)event.getLoggerName(), (StringBuilder)jsonBuilder);
            jsonBuilder.append('\"');
        }
        if (this.includeThreadContext) {
            event.getContextData().forEach(LogstashLayoutV1::appendKeyValue, (Object)jsonBuilder);
        }
        if (this.includeStacktrace && event.getThrown() != null) {
            jsonBuilder.append(",\"stack_trace\":\"");
            this.appendThrowable(event.getThrown(), textBuilder, jsonBuilder);
            jsonBuilder.append('\"');
        }
        if ((message = event.getMessage()) instanceof TaggedMessage) {
            ((TaggedMessage)message).getTags().forEach((Object)jsonBuilder, (TagConsumer)this);
        } else {
            jsonBuilder.append(",\"message\":\"");
            LogstashLayoutV1.appendMessage(message, textBuilder, jsonBuilder);
            jsonBuilder.append('\"');
        }
        jsonBuilder.append('}');
        jsonBuilder.append('\n');
    }

    private static CharSequence toNullSafeString(CharSequence s) {
        return s == null ? "" : s;
    }

    static void appendVersionField(int version, StringBuilder jsonBuilder) {
        jsonBuilder.append("\"@version\":").append(version).append(',');
    }

    static void appendHostField(String host, StringBuilder jsonBuilder) {
        jsonBuilder.append("\"source_host\":\"");
        JsonUtils.quoteAsString((CharSequence)LogstashLayoutV1.toNullSafeString(host), (StringBuilder)jsonBuilder);
        jsonBuilder.append(QC);
    }

    static void appendMessage(Message message, StringBuilder textBuilder, StringBuilder jsonBuilder) {
        if (message instanceof CharSequence) {
            JsonUtils.quoteAsString((CharSequence)((CharSequence)message), (StringBuilder)jsonBuilder);
        } else if (message instanceof StringBuilderFormattable) {
            textBuilder.setLength(0);
            ((StringBuilderFormattable)message).formatTo(textBuilder);
            JsonUtils.quoteAsString((CharSequence)textBuilder, (StringBuilder)jsonBuilder);
        } else {
            JsonUtils.quoteAsString((CharSequence)LogstashLayoutV1.toNullSafeString(message.getFormattedMessage()), (StringBuilder)jsonBuilder);
        }
    }

    static void appendKeyValue(CharSequence key, Object value, StringBuilder stringBuilder) {
        stringBuilder.append(CQU);
        JsonUtils.quoteAsString((CharSequence)key, (StringBuilder)stringBuilder);
        stringBuilder.append("\":\"");
        JsonUtils.quoteAsString((CharSequence)LogstashLayoutV1.toNullSafeString(String.valueOf(value)), (StringBuilder)stringBuilder);
        stringBuilder.append('\"');
    }

    static void appendTaggedTextValue(CharSequence key, Object value, StringBuilder stringBuilder) {
        stringBuilder.append(CQ);
        JsonUtils.quoteAsString((CharSequence)key, (StringBuilder)stringBuilder);
        stringBuilder.append("\":");
        stringBuilder.append('\"');
        JsonUtils.quoteAsString((CharSequence)LogstashLayoutV1.toNullSafeString(String.valueOf(value)), (StringBuilder)stringBuilder);
        stringBuilder.append('\"');
    }

    static void appendTaggedLongValue(CharSequence key, long value, StringBuilder stringBuilder) {
        stringBuilder.append(CQ);
        JsonUtils.quoteAsString((CharSequence)key, (StringBuilder)stringBuilder);
        stringBuilder.append("\":");
        stringBuilder.append(value);
    }

    static void appendTaggedDoubleValue(CharSequence key, double value, StringBuilder stringBuilder) {
        stringBuilder.append(CQ);
        JsonUtils.quoteAsString((CharSequence)key, (StringBuilder)stringBuilder);
        stringBuilder.append("\":");
        stringBuilder.append(value);
    }

    static void appendTaggedBooleanValue(CharSequence key, boolean value, StringBuilder stringBuilder) {
        stringBuilder.append(CQ);
        JsonUtils.quoteAsString((CharSequence)key, (StringBuilder)stringBuilder);
        stringBuilder.append("\":");
        stringBuilder.append(value);
    }

    static void appendTaggedNullValue(CharSequence key, StringBuilder stringBuilder) {
        stringBuilder.append(CQ);
        JsonUtils.quoteAsString((CharSequence)key, (StringBuilder)stringBuilder);
        stringBuilder.append("\":null");
    }

    static StringBuilder appendTimestamp(long timeMillis, StringBuilder stringBuilder) {
        DATE_FORMATTER.format(timeMillis, stringBuilder);
        stringBuilder.append('Z');
        return stringBuilder;
    }

    static StringBuilder appendLevelValue(Level level, StringBuilder stringBuilder) {
        int levelValue = Severity.getSeverity((Level)level).getCode();
        stringBuilder.append(levelValue);
        return stringBuilder;
    }

    void appendThrowable(Throwable throwable, StringBuilder textBuilder, StringBuilder jsonBuilder) {
        textBuilder.setLength(0);
        this.stacktraceFormat.appendThrowable(throwable, textBuilder);
        JsonUtils.quoteAsString((CharSequence)textBuilder, (StringBuilder)jsonBuilder);
    }

    public void textTag(CharSequence key, CharSequence value, StringBuilder stringBuilder) {
        LogstashLayoutV1.appendTaggedTextValue(key, value, stringBuilder);
    }

    public void longTag(CharSequence key, long value, StringBuilder stringBuilder) {
        LogstashLayoutV1.appendTaggedLongValue(key, value, stringBuilder);
    }

    public void booleanTag(CharSequence key, boolean value, StringBuilder stringBuilder) {
        LogstashLayoutV1.appendTaggedBooleanValue(key, value, stringBuilder);
    }

    public void doubleTag(CharSequence key, double value, StringBuilder stringBuilder) {
        LogstashLayoutV1.appendTaggedDoubleValue(key, value, stringBuilder);
    }

    public void nullTag(CharSequence key, StringBuilder stringBuilder) {
        if (this.includeNullTags) {
            LogstashLayoutV1.appendTaggedNullValue(key, stringBuilder);
        }
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractLayout.Builder<B>
    implements org.apache.logging.log4j.core.util.Builder<LogstashLayoutV1> {
        @PluginBuilderAttribute
        @Nullable
        private String host;
        @PluginBuilderAttribute
        private boolean includeStacktrace = true;
        @PluginBuilderAttribute
        @Nullable
        private String stacktracePattern = null;
        @PluginBuilderAttribute
        private int stacktraceMaxLength = Integer.MAX_VALUE;
        @PluginBuilderAttribute
        private int stacktraceMaxFrames = Integer.MAX_VALUE;
        @PluginBuilderAttribute
        private boolean includeThreadContext = true;
        @PluginBuilderAttribute
        private boolean includeTimestamp = true;
        @PluginBuilderAttribute
        private boolean includeNullTags = true;

        public LogstashLayoutV1 build() {
            NameAbbreviator abbreviator = this.stacktracePattern == null ? NameAbbreviator.getDefaultAbbreviator() : NameAbbreviator.getAbbreviator((String)this.stacktracePattern);
            StacktraceFormat stacktraceFormat = new StacktraceFormat(abbreviator, this.stacktraceMaxLength, this.stacktraceMaxFrames);
            return new LogstashLayoutV1(this.getConfiguration(), this.host != null ? this.host : NetUtils.getLocalHostname(), this.includeStacktrace, this.includeThreadContext, this.includeTimestamp, this.includeNullTags, stacktraceFormat);
        }

        @Nullable
        public String getHost() {
            return this.host;
        }

        @Nullable
        public String getStacktracePattern() {
            return this.stacktracePattern;
        }

        public int getStacktraceMaxLength() {
            return this.stacktraceMaxLength;
        }

        public int getStacktraceMaxFrames() {
            return this.stacktraceMaxFrames;
        }

        public boolean isIncludeStacktrace() {
            return this.includeStacktrace;
        }

        public boolean isIncludeThreadContext() {
            return this.includeThreadContext;
        }

        public boolean isIncludeTimestamp() {
            return this.includeTimestamp;
        }

        public boolean isIncludeNullTags() {
            return this.includeNullTags;
        }

        public B setHost(String host) {
            this.host = host;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setStacktracePattern(String stacktracePattern) {
            this.stacktracePattern = stacktracePattern;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setStacktraceMaxLength(int stacktraceMaxLength) {
            this.stacktraceMaxLength = stacktraceMaxLength;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setStacktraceMaxFrames(int stacktraceMaxFrames) {
            this.stacktraceMaxFrames = stacktraceMaxFrames;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setIncludeStacktrace(boolean includeStacktrace) {
            this.includeStacktrace = includeStacktrace;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setIncludeThreadContext(boolean includeThreadContext) {
            this.includeThreadContext = includeThreadContext;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setIncludeTimestamp(boolean includeTimestamp) {
            this.includeTimestamp = includeTimestamp;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setIncludeNullTags(boolean includeNullTags) {
            this.includeNullTags = includeNullTags;
            return (B)((Object)((Builder)this.asBuilder()));
        }
    }

    @FunctionalInterface
    private static interface EventTransformer<T> {
        public T transform(LogEvent var1, StringBuilder var2, StringBuilder var3);
    }

    @FunctionalInterface
    private static interface EventTransformerTo<T> {
        public void transformTo(LogEvent var1, T var2, StringBuilder var3, StringBuilder var4);
    }
}

