/*
 * Decompiled with CFR 0.152.
 */
package se.fnord.logtags.log4j2_logstash.layout;

import java.util.IdentityHashMap;
import org.apache.logging.log4j.core.pattern.NameAbbreviator;

public class StacktraceFormat {
    private final NameAbbreviator nameAbbreviator;
    private final int maxLength;
    private final int maxFrames;

    public StacktraceFormat(NameAbbreviator nameAbbreviator, int maxLength, int maxFrames) {
        this.nameAbbreviator = nameAbbreviator;
        this.maxLength = Math.max(4, maxLength);
        this.maxFrames = Math.max(2, maxFrames);
    }

    public void appendThrowable(Throwable throwable, StringBuilder textBuilder) {
        Formatter formatter = new Formatter(textBuilder);
        formatter.appendThrowable(throwable);
    }

    private class Formatter {
        private final StringBuilder textBuilder;
        private final IdentityHashMap<Throwable, Boolean> handled;
        private final int startPosition;

        private Formatter(StringBuilder textBuilder) {
            this.textBuilder = textBuilder;
            this.startPosition = textBuilder.length();
            this.handled = new IdentityHashMap();
        }

        boolean checkLength() {
            return this.textBuilder.length() - this.startPosition >= StacktraceFormat.this.maxLength;
        }

        private void appendHeader(int indent, String prefix, Throwable throwable) {
            this.indent(indent);
            this.textBuilder.append(prefix);
            StacktraceFormat.this.nameAbbreviator.abbreviate(throwable.getClass().getName(), this.textBuilder);
            String message = throwable.getLocalizedMessage();
            if (message != null) {
                this.textBuilder.append(": ");
                this.textBuilder.append(message);
            }
            this.textBuilder.append("\n");
        }

        private void indent(int indent) {
            this.textBuilder.append("\t".repeat(indent));
        }

        private void appendFileLocation(StackTraceElement element) {
            if (element.isNativeMethod()) {
                this.textBuilder.append("(Native Method)");
                return;
            }
            String fileName = element.getFileName();
            if (fileName == null) {
                this.textBuilder.append("(Unknown Source)");
                return;
            }
            this.textBuilder.append("(").append(fileName);
            int lineNumber = element.getLineNumber();
            if (lineNumber >= 0) {
                this.textBuilder.append(":").append(lineNumber);
            }
            this.textBuilder.append(")");
        }

        private void appendStackTraceElement(int indent, StackTraceElement element) {
            this.indent(indent);
            this.textBuilder.append("at ");
            if (element.getModuleName() != null) {
                StacktraceFormat.this.nameAbbreviator.abbreviate(element.getModuleName(), this.textBuilder);
                this.textBuilder.append('/');
            }
            StacktraceFormat.this.nameAbbreviator.abbreviate(element.getClassName(), this.textBuilder);
            this.textBuilder.append('.');
            this.textBuilder.append(element.getMethodName());
            this.appendFileLocation(element);
            this.textBuilder.append('\n');
        }

        private int appendUntil(StackTraceElement[] elements, StackTraceElement[] parentElements) {
            int maxCommon = Math.min(elements.length, parentElements.length);
            if (maxCommon == 0) {
                return Math.min(StacktraceFormat.this.maxFrames, elements.length);
            }
            int elementIndex = elements.length - 1;
            int parentElementIndex = parentElements.length - 1;
            while (elementIndex >= 0 && elements[elementIndex].equals(parentElements[parentElementIndex])) {
                --elementIndex;
                --parentElementIndex;
            }
            int appendUntil = Math.min(elementIndex + 1, StacktraceFormat.this.maxFrames);
            if (appendUntil == elements.length - 1) {
                return elements.length;
            }
            return appendUntil;
        }

        private void appendStackTraceElements(int indent, StackTraceElement[] elements, StackTraceElement[] parentElements) {
            int appendUntil = this.appendUntil(elements, parentElements);
            for (int i = 0; i < appendUntil; ++i) {
                if (this.checkLength()) {
                    return;
                }
                this.appendStackTraceElement(indent, elements[i]);
            }
            if (appendUntil < elements.length) {
                this.indent(indent);
                this.textBuilder.append("... ");
                this.textBuilder.append(elements.length - appendUntil);
                this.textBuilder.append(" more\n");
            }
        }

        private void adjustLength() {
            if (this.textBuilder.length() - this.startPosition > StacktraceFormat.this.maxLength) {
                this.textBuilder.setLength(this.startPosition + StacktraceFormat.this.maxLength - 4);
                this.textBuilder.append("...\n");
            }
        }

        public void appendThrowable(int indent, String prefix, Throwable throwable, StackTraceElement[] parentElements) {
            if (this.checkLength()) {
                return;
            }
            if (this.handled.put(throwable, Boolean.TRUE) == null) {
                Throwable[] allSuppressed;
                StackTraceElement[] stackTraceElements = throwable.getStackTrace();
                this.appendHeader(indent, prefix, throwable);
                this.appendStackTraceElements(indent + 1, stackTraceElements, parentElements);
                for (Throwable suppressed : allSuppressed = throwable.getSuppressed()) {
                    this.appendThrowable(indent + 1, "Suppressed: ", suppressed, stackTraceElements);
                }
                Throwable cause = throwable.getCause();
                if (cause != null) {
                    this.appendThrowable(indent, "Caused by: ", throwable.getCause(), stackTraceElements);
                }
            }
        }

        public void appendThrowable(Throwable throwable) {
            this.appendThrowable(0, "", throwable, new StackTraceElement[0]);
            this.adjustLength();
        }
    }
}

