/*
 * Decompiled with CFR 0.152.
 */
package se.lovef.assert;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;
import se.lovef.assert.AssertUtilKt;
import se.lovef.assert.check.IterableCheck;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\u001aF\u0010\u0000\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u00022\u000e\u0010\u0003\u001a\n\u0012\u0004\u0012\u0002H\u0002\u0018\u00010\u00042\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u0002H\u0002\u0018\u00010\u00042\u0018\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u00010\u0007\u001aC\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00020\t\"\u0004\b\u0000\u0010\u00022*\u0010\n\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u00010\f0\u000b\"\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u00010\f\u00a2\u0006\u0002\u0010\r\u001aC\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00020\t\"\u0004\b\u0000\u0010\u00022*\u0010\n\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u00010\f0\u000b\"\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u00010\f\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000f"}, d2={"assertPairwise", "", "E", "a", "", "b", "assertionBlock", "Lkotlin/Function2;", "iterableCheck", "Lse/lovef/assert/check/IterableCheck;", "elementChecks", "", "Lkotlin/Function1;", "([Lkotlin/jvm/functions/Function1;)Lse/lovef/assert/check/IterableCheck;", "listCheck", "kotlin-assert-utils_main"})
public final class IterableAssertUtilKt {
    public static final <E> void assertPairwise(@Nullable Iterable<? extends E> a, @Nullable Iterable<? extends E> b, @NotNull Function2<? super E, ? super E, Unit> assertionBlock) {
        Intrinsics.checkParameterIsNotNull(assertionBlock, (String)"assertionBlock");
        if (a == null && b == null) {
            return;
        }
        if (a == null || b == null) {
            throw (Throwable)((Object)new AssertionError((Object)(a + " and " + b + " are both null or both not null")));
        }
        if (a instanceof Collection && b instanceof Collection) {
            AssertUtilKt.proof("a.size == " + ((Collection)a).size() + " == b.size == " + ((Collection)b).size(), (Function0<Unit>)((Function0)new Function0<Unit>(a, b){
                final /* synthetic */ Iterable $a;
                final /* synthetic */ Iterable $b;

                public final void invoke() {
                    AssertUtilKt.isEqualTo(((Collection)this.$a).size(), ((Collection)this.$b).size());
                }
                {
                    this.$a = iterable;
                    this.$b = iterable2;
                    super(0);
                }
            }));
        }
        Iterator<E> iteratorA = a.iterator();
        Iterator<E> iteratorB = b.iterator();
        while (iteratorA.hasNext()) {
            E elementA = iteratorA.next();
            if (!iteratorB.hasNext()) {
                Assert.fail((String)("to few elements in " + b));
            }
            E elementB = iteratorB.next();
            try {
                assertionBlock.invoke(elementA, elementB);
            }
            catch (Throwable t) {
                throw (Throwable)((Object)new AssertionError("Assertion of " + elementA + " and " + elementB + " failed", t));
            }
        }
        if (iteratorB.hasNext()) {
            Assert.fail((String)("to many elements in " + b));
        }
    }

    @NotNull
    public static final <E> IterableCheck<E> iterableCheck(Function1<? super E, Unit> ... elementChecks) {
        Intrinsics.checkParameterIsNotNull(elementChecks, (String)"elementChecks");
        return new IterableCheck<E>(Arrays.copyOf(elementChecks, elementChecks.length));
    }

    @NotNull
    public static final <E> IterableCheck<E> listCheck(Function1<? super E, Unit> ... elementChecks) {
        Intrinsics.checkParameterIsNotNull(elementChecks, (String)"elementChecks");
        return new IterableCheck<E>(Arrays.copyOf(elementChecks, elementChecks.length));
    }
}

