/*
 * Decompiled with CFR 0.152.
 */
package se.lovef.assert.check;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nullable;
import se.lovef.assert.AssertUtilKt;
import se.lovef.assert.check.Check;
import se.lovef.assert.check.ElementCountMismatchError;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00002\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u0002H\u0001\u0018\u00010\u00030\u0002B1\u0012*\u0010\u0004\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\u00060\u0005\"\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0019\u0010\t\u001a\u00020\u00072\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0003H\u0096\u0002R \u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lse/lovef/assert/check/IterableCheck;", "E", "Lse/lovef/assert/check/Check;", "", "elementChecks", "", "Lkotlin/Function1;", "", "([Lkotlin/jvm/functions/Function1;)V", "invoke", "toCheck", "kotlin-assert-utils_main"})
public final class IterableCheck<E>
implements Check<Iterable<? extends E>> {
    private final Iterable<Function1<E, Unit>> elementChecks;

    @Override
    public void invoke(@Nullable Iterable<? extends E> toCheck) {
        AssertUtilKt.isNotNull(toCheck);
        if (toCheck == null) {
            Intrinsics.throwNpe();
        }
        Iterator<Function1<E, Unit>> elementCheckIterator = this.elementChecks.iterator();
        for (E it : toCheck) {
            if (!elementCheckIterator.hasNext()) {
                throw (Throwable)((Object)new ElementCountMismatchError("To many elements in iterable,\n" + ("expected: " + CollectionsKt.count(this.elementChecks) + "\n") + ("actual:   " + CollectionsKt.count(toCheck))));
            }
            Function1<E, Unit> check2 = elementCheckIterator.next();
            check2.invoke(it);
        }
        if (elementCheckIterator.hasNext()) {
            throw (Throwable)((Object)new ElementCountMismatchError("To few elements in iterable,\n" + ("expected: " + CollectionsKt.count(this.elementChecks) + "\n") + ("actual:   " + CollectionsKt.count(toCheck))));
        }
    }

    public IterableCheck(Function1<? super E, Unit> ... elementChecks) {
        Intrinsics.checkParameterIsNotNull(elementChecks, (String)"elementChecks");
        this.elementChecks = ArraysKt.asIterable((Object[])elementChecks);
    }
}

