/*
 * Decompiled with CFR 0.152.
 */
package se.lovef.assert.v1;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsInstanceOf;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;
import se.lovef.assert.v1.Difference;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u00006\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001c\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u0002\u001a\u001b\u0010\u0005\u001a\u00020\u0006*\u00020\u00072\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0086\u0004\u001a*\u0010\t\u001a\u0004\u0018\u0001H\n\"\b\b\u0000\u0010\n*\u00020\u0003*\u0004\u0018\u0001H\n2\b\u0010\u000b\u001a\u0004\u0018\u0001H\nH\u0086\u0004\u00a2\u0006\u0002\u0010\f\u001a>\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\n\u0012\u0004\u0012\u0002H\u000f0\u000e\"\b\b\u0000\u0010\n*\u00020\u0010\"\b\b\u0001\u0010\u000f*\u00020\u0010*\u0004\u0018\u0001H\n2\b\u0010\u000b\u001a\u0004\u0018\u0001H\u000fH\u0086\u0004\u00a2\u0006\u0002\u0010\u0011\u001a\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0013\u001a\u001d\u0010\u0014\u001a\u0004\u0018\u0001H\n\"\b\b\u0000\u0010\n*\u00020\u0003*\u0004\u0018\u0001H\n\u00a2\u0006\u0002\u0010\u0015\u001a\u0013\u0010\u0016\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0013\u001a \u0010\u0017\u001a\u0002H\n\"\u0004\b\u0000\u0010\n*\u0002H\n2\u0006\u0010\u000b\u001a\u0002H\nH\u0086\u0004\u00a2\u0006\u0002\u0010\f\u001a*\u0010\u0018\u001a\u0004\u0018\u0001H\n\"\b\b\u0000\u0010\n*\u00020\u0003*\u0004\u0018\u0001H\n2\b\u0010\u000b\u001a\u0004\u0018\u0001H\nH\u0086\u0004\u00a2\u0006\u0002\u0010\f\u001a\u001b\u0010\u0019\u001a\u0002H\n\"\b\b\u0000\u0010\n*\u00020\u0003*\u0004\u0018\u0001H\n\u00a2\u0006\u0002\u0010\u0015\u001a*\u0010\u001a\u001a\u0004\u0018\u0001H\n\"\b\b\u0000\u0010\n*\u00020\u0003*\u0004\u0018\u0001H\n2\b\u0010\u000b\u001a\u0004\u0018\u0001H\nH\u0086\u0004\u00a2\u0006\u0002\u0010\f\u001a6\u0010\u001b\u001a\u0002H\u000f\"\b\b\u0000\u0010\n*\u00020\u0003\"\b\b\u0001\u0010\u000f*\u00020\u0003*\u0004\u0018\u0001H\n2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u001dH\u0087\u0004\u00a2\u0006\u0002\u0010\u001e\u00a8\u0006\u001f"}, d2={"equals", "", "a", "", "b", "proof", "", "", "Lkotlin/Function0;", "shouldBe", "T", "other", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "shouldBeCloseTo", "Lse/lovef/assert/v1/Difference;", "R", "", "(Ljava/lang/Number;Ljava/lang/Number;)Lse/lovef/assert/v1/Difference;", "shouldBeFalse", "(Ljava/lang/Boolean;)Ljava/lang/Boolean;", "shouldBeNull", "(Ljava/lang/Object;)Ljava/lang/Object;", "shouldBeTrue", "shouldEqual", "shouldNotBe", "shouldNotBeNull", "shouldNotEqual", "typeIs", "type", "Lkotlin/reflect/KClass;", "(Ljava/lang/Object;Lkotlin/reflect/KClass;)Ljava/lang/Object;", "kotlin-assert-utils_main"})
public final class AssertUtilKt {
    @NotNull
    public static final <T, R> R typeIs(@Nullable T $receiver, @NotNull KClass<R> type) {
        Intrinsics.checkParameterIsNotNull(type, (String)"type");
        MatcherAssert.assertThat((String)($receiver + " type is " + JvmClassMappingKt.getJavaClass(type).getSimpleName()), $receiver, (Matcher)((Matcher)new IsInstanceOf(JvmClassMappingKt.getJavaClass(type))));
        T t = $receiver;
        if (t == null) {
            throw new TypeCastException("null cannot be cast to non-null type R");
        }
        return (R)t;
    }

    private static final boolean equals(Object a, Object b) {
        return a instanceof Object[] && b instanceof Object[] ? Arrays.equals((Object[])a, (Object[])b) : (a instanceof byte[] && b instanceof byte[] ? Arrays.equals((byte[])a, (byte[])b) : (a instanceof char[] && b instanceof char[] ? Arrays.equals((char[])a, (char[])b) : (a instanceof short[] && b instanceof short[] ? Arrays.equals((short[])a, (short[])b) : (a instanceof int[] && b instanceof int[] ? Arrays.equals((int[])a, (int[])b) : (a instanceof long[] && b instanceof long[] ? Arrays.equals((long[])a, (long[])b) : (a instanceof float[] && b instanceof float[] ? Arrays.equals((float[])a, (float[])b) : (a instanceof double[] && b instanceof double[] ? Arrays.equals((double[])a, (double[])b) : (a instanceof boolean[] && b instanceof boolean[] ? Arrays.equals((boolean[])a, (boolean[])b) : Intrinsics.areEqual((Object)a, (Object)b)))))))));
    }

    public static final <T> T shouldEqual(T $receiver, T other) {
        Assert.assertTrue((String)("\n" + ("Expected: " + other + "\n") + ("Got:      " + $receiver)), (boolean)AssertUtilKt.equals($receiver, other));
        return other;
    }

    @Nullable
    public static final <T> T shouldNotEqual(@Nullable T $receiver, @Nullable T other) {
        MatcherAssert.assertThat((String)("\n" + ("Expected not: " + other + "\n") + ("Got:          " + $receiver)), (!AssertUtilKt.equals($receiver, other) ? 1 : 0) != 0);
        return other;
    }

    @Nullable
    public static final <T> T shouldBeNull(@Nullable T $receiver) {
        T t;
        T $receiver2 = t = $receiver;
        AssertUtilKt.shouldEqual($receiver2, null);
        return t;
    }

    @NotNull
    public static final <T> T shouldNotBeNull(@Nullable T $receiver) {
        T t;
        T $receiver2 = t = $receiver;
        AssertUtilKt.shouldNotEqual($receiver2, null);
        T t2 = t;
        if (t2 == null) {
            Intrinsics.throwNpe();
        }
        return t2;
    }

    @Nullable
    public static final Boolean shouldBeTrue(@Nullable Boolean $receiver) {
        Boolean bl;
        Boolean $receiver2 = bl = $receiver;
        AssertUtilKt.shouldEqual($receiver2, true);
        return bl;
    }

    @Nullable
    public static final Boolean shouldBeFalse(@Nullable Boolean $receiver) {
        Boolean bl;
        Boolean $receiver2 = bl = $receiver;
        AssertUtilKt.shouldEqual($receiver2, false);
        return bl;
    }

    @Nullable
    public static final <T> T shouldBe(@Nullable T $receiver, @Nullable T other) {
        T t;
        T $receiver2 = t = $receiver;
        Assert.assertTrue((String)("\n" + ("Expected:          " + $receiver2 + "\n") + ("Same reference as: " + other)), ($receiver2 == other ? 1 : 0) != 0);
        return t;
    }

    @Nullable
    public static final <T> T shouldNotBe(@Nullable T $receiver, @Nullable T other) {
        Assert.assertTrue((String)("\n" + ("Expected:              " + $receiver + "\n") + ("Not same reference as: " + other)), ($receiver != other ? 1 : 0) != 0);
        return other;
    }

    @NotNull
    public static final <T extends Number, R extends Number> Difference<T, R> shouldBeCloseTo(@Nullable T $receiver, @Nullable R other) {
        return new Difference<T, R>(AssertUtilKt.shouldNotBeNull($receiver), AssertUtilKt.shouldNotBeNull(other));
    }

    public static final void proof(@NotNull String $receiver, @NotNull Function0<Unit> proof) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(proof, (String)"proof");
        try {
            proof.invoke();
        }
        catch (Throwable throwable) {
            throw (Throwable)((Object)new AssertionError($receiver, throwable));
        }
    }
}

