/*
 * Decompiled with CFR 0.152.
 */
package se.lovef.assert.v1;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;
import se.lovef.assert.v1.AssertUtilKt;
import se.lovef.assert.v1.check.IterableCheck;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u000b\u001aF\u0010\u0000\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u00022\u000e\u0010\u0003\u001a\n\u0012\u0004\u0012\u0002H\u0002\u0018\u00010\u00042\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u0002H\u0002\u0018\u00010\u00042\u0018\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u00010\u0007\u001aC\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00020\t\"\u0004\b\u0000\u0010\u00022*\u0010\n\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u00010\f0\u000b\"\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u00010\f\u00a2\u0006\u0002\u0010\r\u001aC\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00020\t\"\u0004\b\u0000\u0010\u00022*\u0010\n\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u00010\f0\u000b\"\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u00010\f\u00a2\u0006\u0002\u0010\r\u001a%\u0010\u000f\u001a\u0002H\u0010\"\u0004\b\u0000\u0010\u0002\"\u000e\b\u0001\u0010\u0010*\b\u0012\u0004\u0012\u0002H\u00020\u0004*\u0002H\u0010\u00a2\u0006\u0002\u0010\u0011\u001a.\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0004\"\u0004\b\u0000\u0010\u0002*\n\u0012\u0004\u0012\u0002H\u0002\u0018\u00010\u00042\u0006\u0010\u0013\u001a\u0002H\u0002H\u0086\u0004\u00a2\u0006\u0002\u0010\u0014\u001a'\u0010\u0015\u001a\u0002H\u0010\"\u0004\b\u0000\u0010\u0002\"\u000e\b\u0001\u0010\u0010*\b\u0012\u0004\u0012\u0002H\u00020\u0004*\u0004\u0018\u0001H\u0010\u00a2\u0006\u0002\u0010\u0011\u001a0\u0010\u0016\u001a\n\u0012\u0004\u0012\u0002H\u0002\u0018\u00010\u0004\"\u0004\b\u0000\u0010\u0002*\n\u0012\u0004\u0012\u0002H\u0002\u0018\u00010\u00042\u0006\u0010\u0013\u001a\u0002H\u0002H\u0086\u0004\u00a2\u0006\u0002\u0010\u0014\u00a8\u0006\u0017"}, d2={"assertPairwise", "", "E", "a", "", "b", "assertionBlock", "Lkotlin/Function2;", "iterableCheck", "Lse/lovef/assert/v1/check/IterableCheck;", "elementChecks", "", "Lkotlin/Function1;", "([Lkotlin/jvm/functions/Function1;)Lse/lovef/assert/v1/check/IterableCheck;", "listCheck", "shouldBeEmpty", "T", "(Ljava/lang/Iterable;)Ljava/lang/Iterable;", "shouldContain", "element", "(Ljava/lang/Iterable;Ljava/lang/Object;)Ljava/lang/Iterable;", "shouldNotBeEmpty", "shouldNotContain", "kotlin-assert-utils_main"})
public final class IterableAssertUtilKt {
    @NotNull
    public static final <E> Iterable<E> shouldContain(@Nullable Iterable<? extends E> $receiver, E element) {
        if ($receiver == null || !CollectionsKt.contains($receiver, element)) {
            throw (Throwable)((Object)new AssertionError((Object)("Expected to contain " + element + ":" + "\n" + $receiver)));
        }
        return $receiver;
    }

    @Nullable
    public static final <E> Iterable<E> shouldNotContain(@Nullable Iterable<? extends E> $receiver, E element) {
        if ($receiver != null && CollectionsKt.contains($receiver, element)) {
            throw (Throwable)((Object)new AssertionError((Object)("Expected to NOT contain " + element + ":" + "\n" + $receiver)));
        }
        return $receiver;
    }

    @NotNull
    public static final <E, T extends Iterable<? extends E>> T shouldBeEmpty(@NotNull T $receiver) {
        Collection collection;
        T t;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        T $receiver2 = t = $receiver;
        if ($receiver2 instanceof Collection && !(collection = (Collection)$receiver2).isEmpty() || $receiver2.iterator().hasNext()) {
            throw (Throwable)((Object)new AssertionError((Object)("Expected to be empty:" + "\n" + $receiver2)));
        }
        return t;
    }

    @NotNull
    public static final <E, T extends Iterable<? extends E>> T shouldNotBeEmpty(@Nullable T $receiver) {
        T t = $receiver;
        T $receiver2 = t;
        if ($receiver2 == null || $receiver2 instanceof Collection && ((Collection)$receiver2).isEmpty() || !$receiver2.iterator().hasNext()) {
            throw (Throwable)((Object)new AssertionError((Object)("Expected to NOT be empty:" + "\n" + $receiver2)));
        }
        T t2 = t;
        if (t2 == null) {
            Intrinsics.throwNpe();
        }
        return t2;
    }

    public static final <E> void assertPairwise(@Nullable Iterable<? extends E> a, @Nullable Iterable<? extends E> b, @NotNull Function2<? super E, ? super E, Unit> assertionBlock) {
        Intrinsics.checkParameterIsNotNull(assertionBlock, (String)"assertionBlock");
        if (a == null && b == null) {
            return;
        }
        if (a == null || b == null) {
            throw (Throwable)((Object)new AssertionError((Object)(a + " and " + b + " are both null or both not null")));
        }
        if (a instanceof Collection && b instanceof Collection) {
            AssertUtilKt.proof("a.size == " + ((Collection)a).size() + " == b.size == " + ((Collection)b).size(), (Function0<Unit>)((Function0)new Function0<Unit>(a, b){
                final /* synthetic */ Iterable $a;
                final /* synthetic */ Iterable $b;

                public final void invoke() {
                    AssertUtilKt.shouldEqual(((Collection)this.$a).size(), ((Collection)this.$b).size());
                }
                {
                    this.$a = iterable;
                    this.$b = iterable2;
                    super(0);
                }
            }));
        }
        Iterator<E> iteratorA = a.iterator();
        Iterator<E> iteratorB = b.iterator();
        while (iteratorA.hasNext()) {
            E elementA = iteratorA.next();
            if (!iteratorB.hasNext()) {
                Assert.fail((String)("to few elements in " + b));
            }
            E elementB = iteratorB.next();
            try {
                assertionBlock.invoke(elementA, elementB);
            }
            catch (Throwable t) {
                throw (Throwable)((Object)new AssertionError("Assertion of " + elementA + " and " + elementB + " failed", t));
            }
        }
        if (iteratorB.hasNext()) {
            Assert.fail((String)("to many elements in " + b));
        }
    }

    @NotNull
    public static final <E> IterableCheck<E> iterableCheck(Function1<? super E, Unit> ... elementChecks) {
        Intrinsics.checkParameterIsNotNull(elementChecks, (String)"elementChecks");
        return new IterableCheck<E>(Arrays.copyOf(elementChecks, elementChecks.length));
    }

    @NotNull
    public static final <E> IterableCheck<E> listCheck(Function1<? super E, Unit> ... elementChecks) {
        Intrinsics.checkParameterIsNotNull(elementChecks, (String)"elementChecks");
        return new IterableCheck<E>(Arrays.copyOf(elementChecks, elementChecks.length));
    }
}

