/*
 * Decompiled with CFR 0.152.
 */
package com.wrapper.spotify.requests.data.browse;

import com.neovisionaries.i18n.CountryCode;
import com.wrapper.spotify.exceptions.SpotifyWebApiException;
import com.wrapper.spotify.model_objects.specification.Recommendations;
import com.wrapper.spotify.requests.data.AbstractDataRequest;
import java.io.IOException;

public class GetRecommendationsRequest
extends AbstractDataRequest {
    private GetRecommendationsRequest(Builder builder) {
        super(builder);
    }

    public Recommendations execute() throws IOException, SpotifyWebApiException {
        return (Recommendations)new Recommendations.JsonUtil().createModelObject(this.getJson());
    }

    public static final class Builder
    extends AbstractDataRequest.Builder<Builder> {
        public Builder(String accessToken) {
            super(accessToken);
        }

        public Builder limit(Integer limit) {
            assert (1 <= limit && limit <= 100);
            return (Builder)this.setQueryParameter("limit", limit);
        }

        public Builder market(CountryCode market) {
            assert (market != null);
            return (Builder)this.setQueryParameter("market", market);
        }

        public Builder max_acousticness(Float max_acousticness) {
            assert (max_acousticness != null);
            assert (0.0 <= (double)max_acousticness.floatValue() && (double)max_acousticness.floatValue() <= 1.0);
            return (Builder)this.setQueryParameter("max_acousticness", max_acousticness);
        }

        public Builder max_danceability(Float max_danceability) {
            assert (max_danceability != null);
            assert (0.0 <= (double)max_danceability.floatValue() && (double)max_danceability.floatValue() <= 1.0);
            return (Builder)this.setQueryParameter("max_danceability", max_danceability);
        }

        public Builder max_duration_ms(Integer max_duration_ms) {
            assert (max_duration_ms != null);
            return (Builder)this.setQueryParameter("max_duration_ms", max_duration_ms);
        }

        public Builder max_energy(Float max_energy) {
            assert (max_energy != null);
            assert (0.0 <= (double)max_energy.floatValue() && (double)max_energy.floatValue() <= 1.0);
            return (Builder)this.setQueryParameter("max_energy", max_energy);
        }

        public Builder max_instrumentalness(Float max_instrumentalness) {
            assert (max_instrumentalness != null);
            assert (0.0 <= (double)max_instrumentalness.floatValue() && (double)max_instrumentalness.floatValue() <= 1.0);
            return (Builder)this.setQueryParameter("max_instrumentalness", max_instrumentalness);
        }

        public Builder max_key(Integer max_key) {
            assert (max_key != null);
            assert (0 <= max_key && max_key <= 11);
            return (Builder)this.setQueryParameter("max_key", max_key);
        }

        public Builder max_liveness(Float max_liveness) {
            assert (max_liveness != null);
            assert (0.0 <= (double)max_liveness.floatValue() && (double)max_liveness.floatValue() <= 1.0);
            return (Builder)this.setQueryParameter("max_liveness", max_liveness);
        }

        public Builder max_loudness(Float max_loudness) {
            assert (max_loudness != null);
            return (Builder)this.setQueryParameter("max_loudness", max_loudness);
        }

        public Builder max_mode(Integer max_mode) {
            assert (max_mode != null);
            assert (max_mode == 0 || max_mode == 1);
            return (Builder)this.setQueryParameter("max_mode", max_mode);
        }

        public Builder max_popularity(Integer max_popularity) {
            assert (max_popularity != null);
            assert (0 <= max_popularity && max_popularity <= 100);
            return (Builder)this.setQueryParameter("max_popularity", max_popularity);
        }

        public Builder max_speechiness(Float max_speechiness) {
            assert (max_speechiness != null);
            assert (0.0 <= (double)max_speechiness.floatValue() && (double)max_speechiness.floatValue() <= 1.0);
            return (Builder)this.setQueryParameter("max_speechiness", max_speechiness);
        }

        public Builder max_tempo(Float max_tempo) {
            assert (max_tempo != null);
            assert (max_tempo.floatValue() >= 0.0f);
            return (Builder)this.setQueryParameter("max_tempo", max_tempo);
        }

        public Builder max_time_signature(Integer max_time_signature) {
            assert (max_time_signature != null);
            return (Builder)this.setQueryParameter("max_time_signature", max_time_signature);
        }

        public Builder max_valence(Float max_valence) {
            assert (max_valence != null);
            assert (0.0 <= (double)max_valence.floatValue() && (double)max_valence.floatValue() <= 1.0);
            return (Builder)this.setQueryParameter("max_valence", max_valence);
        }

        public Builder min_acousticness(Float min_acousticness) {
            assert (min_acousticness != null);
            assert (0.0 <= (double)min_acousticness.floatValue() && (double)min_acousticness.floatValue() <= 1.0);
            return (Builder)this.setQueryParameter("min_acousticness", min_acousticness);
        }

        public Builder min_danceability(Float min_danceability) {
            assert (min_danceability != null);
            assert (0.0 <= (double)min_danceability.floatValue() && (double)min_danceability.floatValue() <= 1.0);
            return (Builder)this.setQueryParameter("min_danceability", min_danceability);
        }

        public Builder min_duration_ms(Integer min_duration_ms) {
            assert (min_duration_ms != null);
            return (Builder)this.setQueryParameter("min_duration_ms", min_duration_ms);
        }

        public Builder min_energy(Float min_energy) {
            assert (min_energy != null);
            assert (0.0 <= (double)min_energy.floatValue() && (double)min_energy.floatValue() <= 1.0);
            return (Builder)this.setQueryParameter("min_energy", min_energy);
        }

        public Builder min_instrumentalness(Float min_instrumentalness) {
            assert (min_instrumentalness != null);
            assert (0.0 <= (double)min_instrumentalness.floatValue() && (double)min_instrumentalness.floatValue() <= 1.0);
            return (Builder)this.setQueryParameter("min_instrumentalness", min_instrumentalness);
        }

        public Builder min_key(Integer min_key) {
            assert (min_key != null);
            assert (0 <= min_key && min_key <= 11);
            return (Builder)this.setQueryParameter("min_key", min_key);
        }

        public Builder min_liveness(Float min_liveness) {
            assert (min_liveness != null);
            assert (0.0 <= (double)min_liveness.floatValue() && (double)min_liveness.floatValue() <= 1.0);
            return (Builder)this.setQueryParameter("min_liveness", min_liveness);
        }

        public Builder min_loudness(Float min_loudness) {
            assert (min_loudness != null);
            return (Builder)this.setQueryParameter("min_loudness", min_loudness);
        }

        public Builder min_mode(Integer min_mode) {
            assert (min_mode != null);
            assert (min_mode == 0 || min_mode == 1);
            return (Builder)this.setQueryParameter("min_mode", min_mode);
        }

        public Builder min_popularity(Integer min_popularity) {
            assert (min_popularity != null);
            assert (0 <= min_popularity && min_popularity <= 100);
            return (Builder)this.setQueryParameter("min_popularity", min_popularity);
        }

        public Builder min_speechiness(Float min_speechiness) {
            assert (min_speechiness != null);
            assert (0.0 <= (double)min_speechiness.floatValue() && (double)min_speechiness.floatValue() <= 1.0);
            return (Builder)this.setQueryParameter("min_speechiness", min_speechiness);
        }

        public Builder min_tempo(Float min_tempo) {
            assert (min_tempo != null);
            assert (min_tempo.floatValue() >= 0.0f);
            return (Builder)this.setQueryParameter("min_tempo", min_tempo);
        }

        public Builder min_time_signature(Integer min_time_signature) {
            assert (min_time_signature != null);
            return (Builder)this.setQueryParameter("min_time_signature", min_time_signature);
        }

        public Builder min_valence(Float min_valence) {
            assert (min_valence != null);
            assert (0.0 <= (double)min_valence.floatValue() && (double)min_valence.floatValue() <= 1.0);
            return (Builder)this.setQueryParameter("min_valence", min_valence);
        }

        public Builder seed_artists(String seed_artists) {
            assert (seed_artists != null);
            assert (seed_artists.split(",").length <= 5);
            return (Builder)this.setQueryParameter("seed_artists", seed_artists);
        }

        public Builder seed_genres(String seed_genres) {
            assert (seed_genres != null);
            assert (seed_genres.split(",").length <= 5);
            return (Builder)this.setQueryParameter("seed_genres", seed_genres);
        }

        public Builder seed_tracks(String seed_tracks) {
            assert (seed_tracks != null);
            assert (seed_tracks.split(",").length <= 5);
            return (Builder)this.setQueryParameter("seed_tracks", seed_tracks);
        }

        public Builder target_acousticness(Float target_acousticness) {
            assert (target_acousticness != null);
            assert (0.0 <= (double)target_acousticness.floatValue() && (double)target_acousticness.floatValue() <= 1.0);
            return (Builder)this.setQueryParameter("target_acousticness", target_acousticness);
        }

        public Builder target_danceability(Float target_danceability) {
            assert (target_danceability != null);
            assert (0.0 <= (double)target_danceability.floatValue() && (double)target_danceability.floatValue() <= 1.0);
            return (Builder)this.setQueryParameter("target_danceability", target_danceability);
        }

        public Builder target_duration_ms(Integer target_duration_ms) {
            assert (target_duration_ms != null);
            return (Builder)this.setQueryParameter("target_duration_ms", target_duration_ms);
        }

        public Builder target_energy(Float target_energy) {
            assert (target_energy != null);
            assert (0.0 <= (double)target_energy.floatValue() && (double)target_energy.floatValue() <= 1.0);
            return (Builder)this.setQueryParameter("target_energy", target_energy);
        }

        public Builder target_instrumentalness(Float target_instrumentalness) {
            assert (target_instrumentalness != null);
            assert (0.0 <= (double)target_instrumentalness.floatValue() && (double)target_instrumentalness.floatValue() <= 1.0);
            return (Builder)this.setQueryParameter("target_instrumentalness", target_instrumentalness);
        }

        public Builder target_key(Integer target_key) {
            assert (target_key != null);
            assert (0 <= target_key && target_key <= 11);
            return (Builder)this.setQueryParameter("target_key", target_key);
        }

        public Builder target_liveness(Float target_liveness) {
            assert (target_liveness != null);
            assert (0.0 <= (double)target_liveness.floatValue() && (double)target_liveness.floatValue() <= 1.0);
            return (Builder)this.setQueryParameter("target_liveness", target_liveness);
        }

        public Builder target_loudness(Float target_loudness) {
            assert (target_loudness != null);
            return (Builder)this.setQueryParameter("target_loudness", target_loudness);
        }

        public Builder target_mode(Integer target_mode) {
            assert (target_mode != null);
            assert (target_mode == 0 || target_mode == 1);
            return (Builder)this.setQueryParameter("target_mode", target_mode);
        }

        public Builder target_popularity(Integer target_popularity) {
            assert (target_popularity != null);
            assert (0 <= target_popularity && target_popularity <= 100);
            return (Builder)this.setQueryParameter("target_popularity", target_popularity);
        }

        public Builder target_speechiness(Float target_speechiness) {
            assert (target_speechiness != null);
            assert (0.0 <= (double)target_speechiness.floatValue() && (double)target_speechiness.floatValue() <= 1.0);
            return (Builder)this.setQueryParameter("target_speechiness", target_speechiness);
        }

        public Builder target_tempo(Float target_tempo) {
            assert (target_tempo != null);
            assert (target_tempo.floatValue() >= 0.0f);
            return (Builder)this.setQueryParameter("target_tempo", target_tempo);
        }

        public Builder target_time_signature(Integer target_time_signature) {
            assert (target_time_signature != null);
            return (Builder)this.setQueryParameter("target_time_signature", target_time_signature);
        }

        public Builder target_valence(Float target_valence) {
            assert (target_valence != null);
            assert (0.0 <= (double)target_valence.floatValue() && (double)target_valence.floatValue() <= 1.0);
            return (Builder)this.setQueryParameter("target_valence", target_valence);
        }

        @Override
        public GetRecommendationsRequest build() {
            this.setPath("/v1/recommendations");
            return new GetRecommendationsRequest(this);
        }
    }
}

