/*
 * Decompiled with CFR 0.152.
 */
package com.wrapper.spotify.requests.data.follow;

import com.wrapper.spotify.enums.ModelObjectType;
import com.wrapper.spotify.exceptions.SpotifyWebApiException;
import com.wrapper.spotify.model_objects.specification.Artist;
import com.wrapper.spotify.model_objects.specification.PagingCursorbased;
import com.wrapper.spotify.requests.data.AbstractDataRequest;
import java.io.IOException;

public class GetUsersFollowedArtistsRequest
extends AbstractDataRequest {
    private GetUsersFollowedArtistsRequest(Builder builder) {
        super(builder);
    }

    public PagingCursorbased<Artist> execute() throws IOException, SpotifyWebApiException {
        return new Artist.JsonUtil().createModelObjectPagingCursorbased(this.getJson(), "artists");
    }

    public static final class Builder
    extends AbstractDataRequest.Builder<Builder> {
        public Builder(String accessToken) {
            super(accessToken);
        }

        public Builder type(ModelObjectType type) {
            assert (type != null);
            assert (type.getType().equals("artist"));
            return (Builder)this.setQueryParameter("type", (Object)type);
        }

        public Builder limit(Integer limit) {
            assert (limit != null);
            assert (1 <= limit && limit <= 50);
            return (Builder)this.setQueryParameter("limit", limit);
        }

        public Builder after(String after) {
            assert (after != null);
            return (Builder)this.setQueryParameter("after", after);
        }

        @Override
        public GetUsersFollowedArtistsRequest build() {
            this.setPath("/v1/me/following");
            return new GetUsersFollowedArtistsRequest(this);
        }
    }
}

