/*
 * Decompiled with CFR 0.152.
 */
package com.wrapper.spotify.requests.data.player;

import com.wrapper.spotify.SpotifyApi;
import com.wrapper.spotify.exceptions.SpotifyWebApiException;
import com.wrapper.spotify.model_objects.specification.PagingCursorbased;
import com.wrapper.spotify.model_objects.specification.PlayHistory;
import com.wrapper.spotify.requests.data.AbstractDataRequest;
import java.io.IOException;
import java.util.Date;

public class GetCurrentUsersRecentlyPlayedTracksRequest
extends AbstractDataRequest {
    private GetCurrentUsersRecentlyPlayedTracksRequest(Builder builder) {
        super(builder);
    }

    public PagingCursorbased<PlayHistory> execute() throws IOException, SpotifyWebApiException {
        return new PlayHistory.JsonUtil().createModelObjectPagingCursorbased(this.getJson());
    }

    public static final class Builder
    extends AbstractDataRequest.Builder<Builder> {
        public Builder(String accessToken) {
            super(accessToken);
        }

        public Builder limit(Integer limit) {
            assert (limit != null);
            assert (1 <= limit && limit <= 50);
            return (Builder)this.setQueryParameter("limit", limit);
        }

        public Builder after(Date after) {
            assert (after != null);
            return (Builder)this.setQueryParameter("after", SpotifyApi.SIMPLE_DATE_FORMAT.format(after));
        }

        public Builder before(Date before) {
            assert (before != null);
            return (Builder)this.setQueryParameter("before", SpotifyApi.SIMPLE_DATE_FORMAT.format(before));
        }

        @Override
        public GetCurrentUsersRecentlyPlayedTracksRequest build() {
            this.setPath("/v1/me/player/recently-played");
            return new GetCurrentUsersRecentlyPlayedTracksRequest(this);
        }
    }
}

