/*
 * Decompiled with CFR 0.152.
 */
package com.wrapper.spotify.requests.data.playlists;

import com.wrapper.spotify.exceptions.SpotifyWebApiException;
import com.wrapper.spotify.model_objects.special.SnapshotResult;
import com.wrapper.spotify.requests.data.AbstractDataRequest;
import java.io.IOException;
import org.apache.http.entity.ContentType;

public class ReorderPlaylistsTracksRequest
extends AbstractDataRequest {
    private ReorderPlaylistsTracksRequest(Builder builder) {
        super(builder);
    }

    public SnapshotResult execute() throws IOException, SpotifyWebApiException {
        return (SnapshotResult)new SnapshotResult.JsonUtil().createModelObject(this.putJson());
    }

    public static final class Builder
    extends AbstractDataRequest.Builder<Builder> {
        public Builder(String accessToken) {
            super(accessToken);
        }

        public Builder user_id(String user_id) {
            assert (user_id != null);
            assert (!user_id.equals(""));
            return (Builder)this.setPathParameter("user_id", user_id);
        }

        public Builder playlist_id(String playlist_id) {
            assert (playlist_id != null);
            assert (!playlist_id.equals(""));
            return (Builder)this.setPathParameter("playlist_id", playlist_id);
        }

        public Builder range_start(Integer range_start) {
            assert (range_start != null);
            assert (range_start >= 0);
            return (Builder)this.setBodyParameter("range_start", range_start);
        }

        public Builder range_length(Integer range_length) {
            assert (range_length != null);
            assert (range_length >= 1);
            return (Builder)this.setBodyParameter("range_length", range_length);
        }

        public Builder insert_before(Integer insert_before) {
            assert (insert_before != null);
            assert (insert_before >= 0);
            return (Builder)this.setBodyParameter("insert_before", insert_before);
        }

        public Builder snapshot_id(String snapshot_id) {
            assert (snapshot_id != null);
            assert (!snapshot_id.equals(""));
            return (Builder)this.setBodyParameter("snapshot_id", snapshot_id);
        }

        @Override
        public ReorderPlaylistsTracksRequest build() {
            this.setContentType(ContentType.APPLICATION_JSON);
            this.setPath("/v1/users/{user_id}/playlists/{playlist_id}/tracks");
            return new ReorderPlaylistsTracksRequest(this);
        }
    }
}

