/*
 * Decompiled with CFR 0.152.
 */
package com.wrapper.spotify.requests.data.browse;

import com.neovisionaries.i18n.CountryCode;
import com.neovisionaries.i18n.LanguageCode;
import com.wrapper.spotify.exceptions.SpotifyWebApiException;
import com.wrapper.spotify.model_objects.specification.Category;
import com.wrapper.spotify.model_objects.specification.Paging;
import com.wrapper.spotify.requests.data.AbstractDataRequest;
import java.io.IOException;

public class GetListOfCategoriesRequest
extends AbstractDataRequest {
    private GetListOfCategoriesRequest(Builder builder) {
        super(builder);
    }

    public Paging<Category> execute() throws IOException, SpotifyWebApiException {
        return new Category.JsonUtil().createModelObjectPaging(this.getJson(), "categories");
    }

    public static final class Builder
    extends AbstractDataRequest.Builder<Builder> {
        public Builder(String accessToken) {
            super(accessToken);
        }

        public Builder country(CountryCode country) {
            assert (country != null);
            return (Builder)this.setQueryParameter("country", country);
        }

        public Builder locale(String locale) {
            assert (locale != null);
            assert (locale.contains("_"));
            String[] localeParts = locale.split("_");
            assert (localeParts.length == 2);
            assert (LanguageCode.getByCode((String)localeParts[0]) != null);
            assert (CountryCode.getByCode((String)localeParts[1]) != null);
            return (Builder)this.setQueryParameter("locale", locale);
        }

        public Builder limit(Integer limit) {
            assert (1 <= limit && limit <= 50);
            return (Builder)this.setQueryParameter("limit", limit);
        }

        public Builder offset(Integer offset) {
            assert (offset >= 0);
            return (Builder)this.setQueryParameter("offset", offset);
        }

        @Override
        public GetListOfCategoriesRequest build() {
            this.setPath("/v1/browse/categories");
            return new GetListOfCategoriesRequest(this);
        }
    }
}

