/*
 * Decompiled with CFR 0.152.
 */
package com.wrapper.spotify.requests.data.personalization.simplified;

import com.wrapper.spotify.exceptions.SpotifyWebApiException;
import com.wrapper.spotify.model_objects.specification.Paging;
import com.wrapper.spotify.model_objects.specification.Track;
import com.wrapper.spotify.requests.data.AbstractDataRequest;
import java.io.IOException;

public class GetUsersTopTracksRequest
extends AbstractDataRequest {
    private GetUsersTopTracksRequest(Builder builder) {
        super(builder);
    }

    public Paging<Track> execute() throws IOException, SpotifyWebApiException {
        return new Track.JsonUtil().createModelObjectPaging(this.getJson());
    }

    public static final class Builder
    extends AbstractDataRequest.Builder<Builder> {
        public Builder(String accessToken) {
            super(accessToken);
        }

        public Builder limit(Integer limit) {
            assert (limit != null);
            assert (1 <= limit && limit <= 50);
            return (Builder)this.setQueryParameter("limit", limit);
        }

        public Builder offset(Integer offset) {
            assert (offset >= 0);
            return (Builder)this.setQueryParameter("offset", offset);
        }

        public Builder time_range(String time_range) {
            assert (time_range != null);
            assert (time_range.equals("long_term") || time_range.equals("medium_term") || time_range.equals("short_term"));
            return (Builder)this.setQueryParameter("time_range", time_range);
        }

        @Override
        public GetUsersTopTracksRequest build() {
            this.setPath("/v1/me/top/tracks");
            return new GetUsersTopTracksRequest(this);
        }
    }
}

