/*
 * Decompiled with CFR 0.152.
 */
package com.wrapper.spotify.requests.data.playlists;

import com.neovisionaries.i18n.CountryCode;
import com.wrapper.spotify.exceptions.SpotifyWebApiException;
import com.wrapper.spotify.model_objects.specification.Playlist;
import com.wrapper.spotify.requests.data.AbstractDataRequest;
import java.io.IOException;

public class GetPlaylistRequest
extends AbstractDataRequest {
    private GetPlaylistRequest(Builder builder) {
        super(builder);
    }

    public Playlist execute() throws IOException, SpotifyWebApiException {
        return (Playlist)new Playlist.JsonUtil().createModelObject(this.getJson());
    }

    public static final class Builder
    extends AbstractDataRequest.Builder<Builder> {
        public Builder(String accessToken) {
            super(accessToken);
        }

        @Deprecated
        public Builder user_id(String user_id) {
            assert (user_id != null);
            assert (!user_id.equals(""));
            return (Builder)this.setPathParameter("user_id", user_id);
        }

        public Builder playlist_id(String playlist_id) {
            assert (playlist_id != null);
            assert (!playlist_id.equals(""));
            return (Builder)this.setPathParameter("playlist_id", playlist_id);
        }

        public Builder fields(String fields) {
            assert (fields != null);
            assert (!fields.equals(""));
            return (Builder)this.setQueryParameter("fields", fields);
        }

        public Builder market(CountryCode market) {
            assert (market != null);
            return (Builder)this.setQueryParameter("market", market);
        }

        @Override
        public GetPlaylistRequest build() {
            this.setPath("/v1/playlists/{playlist_id}");
            return new GetPlaylistRequest(this);
        }
    }
}

