/*
 * Decompiled with CFR 0.152.
 */
package com.wrapper.spotify.requests.data.playlists;

import com.google.gson.JsonArray;
import com.wrapper.spotify.exceptions.SpotifyWebApiException;
import com.wrapper.spotify.model_objects.special.SnapshotResult;
import com.wrapper.spotify.requests.data.AbstractDataRequest;
import java.io.IOException;
import org.apache.http.entity.ContentType;

public class RemoveTracksFromPlaylistRequest
extends AbstractDataRequest {
    private RemoveTracksFromPlaylistRequest(Builder builder) {
        super(builder);
    }

    public SnapshotResult execute() throws IOException, SpotifyWebApiException {
        return (SnapshotResult)new SnapshotResult.JsonUtil().createModelObject(this.deleteJson());
    }

    public static final class Builder
    extends AbstractDataRequest.Builder<Builder> {
        public Builder(String accessToken) {
            super(accessToken);
        }

        @Deprecated
        public Builder user_id(String user_id) {
            assert (user_id != null);
            assert (!user_id.equals(""));
            return (Builder)this.setPathParameter("user_id", user_id);
        }

        public Builder playlist_id(String playlist_id) {
            assert (playlist_id != null);
            assert (!playlist_id.equals(""));
            return (Builder)this.setPathParameter("playlist_id", playlist_id);
        }

        public Builder tracks(JsonArray tracks) {
            assert (tracks != null);
            assert (!tracks.isJsonNull());
            assert (tracks.size() <= 100);
            return (Builder)this.setBodyParameter("tracks", tracks);
        }

        public Builder snapshotId(String snapshotId) {
            assert (snapshotId != null);
            assert (!snapshotId.equals(""));
            return (Builder)this.setBodyParameter("snapshot_id", snapshotId);
        }

        @Override
        public RemoveTracksFromPlaylistRequest build() {
            this.setContentType(ContentType.APPLICATION_JSON);
            this.setPath("/v1/playlists/{playlist_id}/tracks");
            return new RemoveTracksFromPlaylistRequest(this);
        }
    }
}

