/*
 * Decompiled with CFR 0.152.
 */
package com.wrapper.spotify.model_objects.special;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.gson.JsonObject;
import com.wrapper.spotify.model_objects.AbstractModelObject;
import com.wrapper.spotify.model_objects.specification.Paging;
import com.wrapper.spotify.model_objects.specification.PlaylistSimplified;

@JsonDeserialize(builder=Builder.class)
public class FeaturedPlaylists
extends AbstractModelObject {
    private final String message;
    private final Paging<PlaylistSimplified> playlists;

    private FeaturedPlaylists(Builder builder) {
        super(builder);
        this.message = builder.message;
        this.playlists = builder.playlists;
    }

    public String getMessage() {
        return this.message;
    }

    public Paging<PlaylistSimplified> getPlaylists() {
        return this.playlists;
    }

    @Override
    public Builder builder() {
        return new Builder();
    }

    public static final class JsonUtil
    extends AbstractModelObject.JsonUtil<FeaturedPlaylists> {
        @Override
        public FeaturedPlaylists createModelObject(JsonObject jsonObject) {
            if (jsonObject == null || jsonObject.isJsonNull()) {
                return null;
            }
            return new Builder().setMessage(this.hasAndNotNull(jsonObject, "message") ? jsonObject.get("message").getAsString() : null).setPlaylists(this.hasAndNotNull(jsonObject, "playlists") ? new PlaylistSimplified.JsonUtil().createModelObjectPaging(jsonObject.getAsJsonObject("playlists")) : null).build();
        }
    }

    public static final class Builder
    extends AbstractModelObject.Builder {
        private String message;
        private Paging<PlaylistSimplified> playlists;

        public Builder setMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder setPlaylists(Paging<PlaylistSimplified> playlists) {
            this.playlists = playlists;
            return this;
        }

        @Override
        public FeaturedPlaylists build() {
            return new FeaturedPlaylists(this);
        }
    }
}

