/*
 * Decompiled with CFR 0.152.
 */
package com.wrapper.spotify.model_objects.specification;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.gson.JsonObject;
import com.wrapper.spotify.model_objects.AbstractModelObject;
import com.wrapper.spotify.model_objects.specification.RecommendationsSeed;
import com.wrapper.spotify.model_objects.specification.TrackSimplified;

@JsonDeserialize(builder=Builder.class)
public class Recommendations
extends AbstractModelObject {
    private final RecommendationsSeed[] seeds;
    private final TrackSimplified[] tracks;

    private Recommendations(Builder builder) {
        super(builder);
        this.seeds = builder.seeds;
        this.tracks = builder.tracks;
    }

    public RecommendationsSeed[] getSeeds() {
        return this.seeds;
    }

    public TrackSimplified[] getTracks() {
        return this.tracks;
    }

    @Override
    public Builder builder() {
        return new Builder();
    }

    public static final class JsonUtil
    extends AbstractModelObject.JsonUtil<Recommendations> {
        @Override
        public Recommendations createModelObject(JsonObject jsonObject) {
            if (jsonObject == null || jsonObject.isJsonNull()) {
                return null;
            }
            return new Builder().setSeeds(this.hasAndNotNull(jsonObject, "seeds") ? (RecommendationsSeed[])new RecommendationsSeed.JsonUtil().createModelObjectArray(jsonObject.getAsJsonArray("seeds")) : null).setTracks(this.hasAndNotNull(jsonObject, "tracks") ? (TrackSimplified[])new TrackSimplified.JsonUtil().createModelObjectArray(jsonObject.getAsJsonArray("tracks")) : null).build();
        }
    }

    public static final class Builder
    extends AbstractModelObject.Builder {
        private RecommendationsSeed[] seeds;
        private TrackSimplified[] tracks;

        public Builder setSeeds(RecommendationsSeed ... seeds) {
            this.seeds = seeds;
            return this;
        }

        public Builder setTracks(TrackSimplified ... tracks) {
            this.tracks = tracks;
            return this;
        }

        @Override
        public Recommendations build() {
            return new Recommendations(this);
        }
    }
}

