/*
 * Decompiled with CFR 0.152.
 */
package com.wrapper.spotify.model_objects.specification;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.gson.JsonObject;
import com.wrapper.spotify.SpotifyApi;
import com.wrapper.spotify.model_objects.AbstractModelObject;
import com.wrapper.spotify.model_objects.specification.Album;
import java.text.ParseException;
import java.util.Date;
import java.util.logging.Level;

@JsonDeserialize(builder=Builder.class)
public class SavedAlbum
extends AbstractModelObject {
    private final Date addedAt;
    private final Album album;

    private SavedAlbum(Builder builder) {
        super(builder);
        this.addedAt = builder.addedAt;
        this.album = builder.album;
    }

    public Date getAddedAt() {
        return this.addedAt;
    }

    public Album getAlbum() {
        return this.album;
    }

    @Override
    public Builder builder() {
        return new Builder();
    }

    public static final class JsonUtil
    extends AbstractModelObject.JsonUtil<SavedAlbum> {
        @Override
        public SavedAlbum createModelObject(JsonObject jsonObject) {
            if (jsonObject == null || jsonObject.isJsonNull()) {
                return null;
            }
            try {
                return new Builder().setAddedAt(this.hasAndNotNull(jsonObject, "added_at") ? SpotifyApi.parseDefaultDate(jsonObject.get("added_at").getAsString()) : null).setAlbum(this.hasAndNotNull(jsonObject, "album") ? new Album.JsonUtil().createModelObject(jsonObject.getAsJsonObject("album")) : null).build();
            }
            catch (ParseException e) {
                SpotifyApi.LOGGER.log(Level.SEVERE, e.getMessage());
                return null;
            }
        }
    }

    public static final class Builder
    extends AbstractModelObject.Builder {
        private Date addedAt;
        private Album album;

        public Builder setAddedAt(Date addedAt) {
            this.addedAt = addedAt;
            return this;
        }

        public Builder setAlbum(Album album) {
            this.album = album;
            return this;
        }

        @Override
        public SavedAlbum build() {
            return new SavedAlbum(this);
        }
    }
}

