/*
 * Decompiled with CFR 0.152.
 */
package com.wrapper.spotify.requests;

import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.wrapper.spotify.IHttpManager;
import com.wrapper.spotify.exceptions.SpotifyWebApiException;
import com.wrapper.spotify.requests.AbstractRequest;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.concurrent.Future;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.entity.ContentType;

public interface IRequest<T> {
    public IHttpManager getHttpManager();

    public URI getUri();

    public List<Header> getHeaders();

    public ContentType getContentType();

    public HttpEntity getBody();

    public List<NameValuePair> getBodyParameters();

    public T execute() throws IOException, SpotifyWebApiException;

    public Future<T> executeAsync();

    public String getJson() throws IOException, SpotifyWebApiException;

    public String postJson() throws IOException, SpotifyWebApiException;

    public String putJson() throws IOException, SpotifyWebApiException;

    public String deleteJson() throws IOException, SpotifyWebApiException;

    @JsonPOJOBuilder(withPrefix="set")
    public static interface Builder<T, X> {
        public Builder setHttpManager(IHttpManager var1);

        public Builder setScheme(String var1);

        public Builder setHost(String var1);

        public Builder setPort(Integer var1);

        public Builder setPath(String var1);

        public Builder setPathParameter(String var1, String var2);

        public Builder setDefaults(IHttpManager var1, String var2, String var3, Integer var4);

        public <ST> Builder setQueryParameter(String var1, ST var2);

        public <ST> Builder setHeader(String var1, ST var2);

        public Builder setContentType(ContentType var1);

        public Builder setBody(HttpEntity var1);

        public <ST> Builder setBodyParameter(String var1, ST var2);

        public AbstractRequest<T> build();
    }
}

