/*
 * Decompiled with CFR 0.152.
 */
package com.wrapper.spotify.requests.data.albums;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.neovisionaries.i18n.CountryCode;
import com.wrapper.spotify.exceptions.SpotifyWebApiException;
import com.wrapper.spotify.model_objects.specification.Album;
import com.wrapper.spotify.requests.data.AbstractDataRequest;
import java.io.IOException;

@JsonDeserialize(builder=Builder.class)
public class GetSeveralAlbumsRequest
extends AbstractDataRequest<Album[]> {
    private GetSeveralAlbumsRequest(Builder builder) {
        super(builder);
    }

    @Override
    public Album[] execute() throws IOException, SpotifyWebApiException {
        return (Album[])new Album.JsonUtil().createModelObjectArray(this.getJson(), "albums");
    }

    public static final class Builder
    extends AbstractDataRequest.Builder<Album[], Builder> {
        public Builder(String accessToken) {
            super(accessToken);
        }

        public Builder ids(String ids) {
            assert (ids != null);
            assert (ids.split(",").length <= 20);
            return (Builder)this.setQueryParameter("ids", ids);
        }

        public Builder market(CountryCode market) {
            assert (market != null);
            return (Builder)this.setQueryParameter("market", market);
        }

        public GetSeveralAlbumsRequest build() {
            this.setPath("/v1/albums");
            return new GetSeveralAlbumsRequest(this);
        }
    }
}

