/*
 * Decompiled with CFR 0.152.
 */
package com.wrapper.spotify.requests.data.artists;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.neovisionaries.i18n.CountryCode;
import com.wrapper.spotify.exceptions.SpotifyWebApiException;
import com.wrapper.spotify.model_objects.specification.AlbumSimplified;
import com.wrapper.spotify.model_objects.specification.Paging;
import com.wrapper.spotify.requests.data.AbstractDataPagingRequest;
import com.wrapper.spotify.requests.data.AbstractDataRequest;
import java.io.IOException;

@JsonDeserialize(builder=Builder.class)
public class GetArtistsAlbumsRequest
extends AbstractDataRequest<Paging<AlbumSimplified>> {
    private GetArtistsAlbumsRequest(Builder builder) {
        super(builder);
    }

    @Override
    public Paging<AlbumSimplified> execute() throws IOException, SpotifyWebApiException {
        return new AlbumSimplified.JsonUtil().createModelObjectPaging(this.getJson());
    }

    public static final class Builder
    extends AbstractDataPagingRequest.Builder<AlbumSimplified, Builder> {
        public Builder(String accessToken) {
            super(accessToken);
        }

        public Builder id(String id) {
            assert (id != null);
            assert (!id.equals(""));
            return (Builder)this.setPathParameter("id", id);
        }

        public Builder album_type(String album_type) {
            assert (album_type != null);
            assert (album_type.matches("((^|,)(single|album|appears_on|compilation))+$"));
            return (Builder)this.setQueryParameter("album_type", album_type);
        }

        public Builder market(CountryCode market) {
            assert (market != null);
            return (Builder)this.setQueryParameter("market", market);
        }

        @Override
        public Builder limit(Integer limit) {
            assert (1 <= limit && limit <= 50);
            return (Builder)this.setQueryParameter("limit", limit);
        }

        @Override
        public Builder offset(Integer offset) {
            assert (offset >= 0);
            return (Builder)this.setQueryParameter("offset", offset);
        }

        public GetArtistsAlbumsRequest build() {
            this.setPath("/v1/artists/{id}/albums");
            return new GetArtistsAlbumsRequest(this);
        }
    }
}

