/*
 * Decompiled with CFR 0.152.
 */
package com.wrapper.spotify.requests.data.browse;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.neovisionaries.i18n.CountryCode;
import com.neovisionaries.i18n.LanguageCode;
import com.wrapper.spotify.exceptions.SpotifyWebApiException;
import com.wrapper.spotify.model_objects.specification.Category;
import com.wrapper.spotify.requests.data.AbstractDataRequest;
import java.io.IOException;

@JsonDeserialize(builder=Builder.class)
public class GetCategoryRequest
extends AbstractDataRequest<Category> {
    private GetCategoryRequest(Builder builder) {
        super(builder);
    }

    @Override
    public Category execute() throws IOException, SpotifyWebApiException {
        return (Category)new Category.JsonUtil().createModelObject(this.getJson());
    }

    public static final class Builder
    extends AbstractDataRequest.Builder<Category, Builder> {
        public Builder(String accessToken) {
            super(accessToken);
        }

        public Builder category_id(String category_id) {
            assert (category_id != null);
            assert (category_id.matches("^[a-z]+$"));
            return (Builder)this.setPathParameter("category_id", category_id);
        }

        public Builder country(CountryCode country) {
            assert (country != null);
            return (Builder)this.setQueryParameter("country", country);
        }

        public Builder locale(String locale) {
            assert (locale != null);
            assert (locale.contains("_"));
            String[] localeParts = locale.split("_");
            assert (localeParts.length == 2);
            assert (LanguageCode.getByCode((String)localeParts[0]) != null);
            assert (CountryCode.getByCode((String)localeParts[1]) != null);
            return (Builder)this.setQueryParameter("locale", locale);
        }

        public GetCategoryRequest build() {
            this.setPath("/v1/browse/categories/{category_id}");
            return new GetCategoryRequest(this);
        }
    }
}

