/*
 * Decompiled with CFR 0.152.
 */
package com.wrapper.spotify.requests.data.browse;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.neovisionaries.i18n.CountryCode;
import com.wrapper.spotify.exceptions.SpotifyWebApiException;
import com.wrapper.spotify.model_objects.specification.Paging;
import com.wrapper.spotify.model_objects.specification.PlaylistSimplified;
import com.wrapper.spotify.requests.data.AbstractDataPagingRequest;
import com.wrapper.spotify.requests.data.AbstractDataRequest;
import java.io.IOException;

@JsonDeserialize(builder=Builder.class)
public class GetCategorysPlaylistsRequest
extends AbstractDataRequest<Paging<PlaylistSimplified>> {
    private GetCategorysPlaylistsRequest(Builder builder) {
        super(builder);
    }

    @Override
    public Paging<PlaylistSimplified> execute() throws IOException, SpotifyWebApiException {
        return new PlaylistSimplified.JsonUtil().createModelObjectPaging(this.getJson(), "playlists");
    }

    public static final class Builder
    extends AbstractDataPagingRequest.Builder<PlaylistSimplified, Builder> {
        public Builder(String accessToken) {
            super(accessToken);
        }

        public Builder category_id(String category_id) {
            assert (category_id != null);
            assert (category_id.matches("^[a-z]+$"));
            return (Builder)this.setPathParameter("category_id", category_id);
        }

        public Builder country(CountryCode country) {
            assert (country != null);
            return (Builder)this.setQueryParameter("country", country);
        }

        @Override
        public Builder limit(Integer limit) {
            assert (1 <= limit && limit <= 50);
            return (Builder)this.setQueryParameter("limit", limit);
        }

        @Override
        public Builder offset(Integer offset) {
            assert (offset >= 0);
            return (Builder)this.setQueryParameter("offset", offset);
        }

        public GetCategorysPlaylistsRequest build() {
            this.setPath("/v1/browse/categories/{category_id}/playlists");
            return new GetCategorysPlaylistsRequest(this);
        }
    }
}

