/*
 * Decompiled with CFR 0.152.
 */
package com.wrapper.spotify.requests.data.browse;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.neovisionaries.i18n.CountryCode;
import com.wrapper.spotify.exceptions.SpotifyWebApiException;
import com.wrapper.spotify.model_objects.specification.AlbumSimplified;
import com.wrapper.spotify.model_objects.specification.Paging;
import com.wrapper.spotify.requests.data.AbstractDataPagingRequest;
import com.wrapper.spotify.requests.data.AbstractDataRequest;
import java.io.IOException;

@JsonDeserialize(builder=Builder.class)
public class GetListOfNewReleasesRequest
extends AbstractDataRequest<Paging<AlbumSimplified>> {
    private GetListOfNewReleasesRequest(Builder builder) {
        super(builder);
    }

    @Override
    public Paging<AlbumSimplified> execute() throws IOException, SpotifyWebApiException {
        return new AlbumSimplified.JsonUtil().createModelObjectPaging(this.getJson(), "albums");
    }

    public static final class Builder
    extends AbstractDataPagingRequest.Builder<AlbumSimplified, Builder> {
        public Builder(String accessToken) {
            super(accessToken);
        }

        public Builder country(CountryCode country) {
            assert (country != null);
            return (Builder)this.setQueryParameter("country", country);
        }

        @Override
        public Builder limit(Integer limit) {
            assert (1 <= limit && limit <= 50);
            return (Builder)this.setQueryParameter("limit", limit);
        }

        @Override
        public Builder offset(Integer offset) {
            assert (offset >= 0);
            return (Builder)this.setQueryParameter("offset", offset);
        }

        public GetListOfNewReleasesRequest build() {
            this.setPath("/v1/browse/new-releases");
            return new GetListOfNewReleasesRequest(this);
        }
    }
}

