/*
 * Decompiled with CFR 0.152.
 */
package com.wrapper.spotify.requests.data.follow;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.wrapper.spotify.enums.ModelObjectType;
import com.wrapper.spotify.exceptions.SpotifyWebApiException;
import com.wrapper.spotify.model_objects.specification.Artist;
import com.wrapper.spotify.model_objects.specification.PagingCursorbased;
import com.wrapper.spotify.requests.data.AbstractDataPagingCursorbasedRequest;
import com.wrapper.spotify.requests.data.AbstractDataRequest;
import java.io.IOException;

@JsonDeserialize(builder=Builder.class)
public class GetUsersFollowedArtistsRequest
extends AbstractDataRequest<PagingCursorbased<Artist>> {
    private GetUsersFollowedArtistsRequest(Builder builder) {
        super(builder);
    }

    @Override
    public PagingCursorbased<Artist> execute() throws IOException, SpotifyWebApiException {
        return new Artist.JsonUtil().createModelObjectPagingCursorbased(this.getJson(), "artists");
    }

    public static final class Builder
    extends AbstractDataPagingCursorbasedRequest.Builder<Artist, String, Builder> {
        public Builder(String accessToken) {
            super(accessToken);
        }

        public Builder type(ModelObjectType type) {
            assert (type != null);
            assert (type.getType().equals("artist"));
            return (Builder)this.setQueryParameter("type", (Object)type);
        }

        @Override
        public Builder limit(Integer limit) {
            assert (limit != null);
            assert (1 <= limit && limit <= 50);
            return (Builder)this.setQueryParameter("limit", limit);
        }

        @Override
        public Builder after(String after) {
            assert (after != null);
            return (Builder)this.setQueryParameter("after", after);
        }

        public GetUsersFollowedArtistsRequest build() {
            this.setPath("/v1/me/following");
            return new GetUsersFollowedArtistsRequest(this);
        }
    }
}

