/*
 * Decompiled with CFR 0.152.
 */
package com.wrapper.spotify.requests.data.library;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.neovisionaries.i18n.CountryCode;
import com.wrapper.spotify.exceptions.SpotifyWebApiException;
import com.wrapper.spotify.model_objects.specification.Paging;
import com.wrapper.spotify.model_objects.specification.SavedAlbum;
import com.wrapper.spotify.requests.data.AbstractDataPagingRequest;
import com.wrapper.spotify.requests.data.AbstractDataRequest;
import java.io.IOException;

@JsonDeserialize(builder=Builder.class)
public class GetCurrentUsersSavedAlbumsRequest
extends AbstractDataRequest<Paging<SavedAlbum>> {
    private GetCurrentUsersSavedAlbumsRequest(Builder builder) {
        super(builder);
    }

    @Override
    public Paging<SavedAlbum> execute() throws IOException, SpotifyWebApiException {
        return new SavedAlbum.JsonUtil().createModelObjectPaging(this.getJson());
    }

    public static final class Builder
    extends AbstractDataPagingRequest.Builder<SavedAlbum, Builder> {
        public Builder(String accessToken) {
            super(accessToken);
        }

        @Override
        public Builder limit(Integer limit) {
            assert (1 <= limit && limit <= 50);
            return (Builder)this.setQueryParameter("limit", limit);
        }

        @Override
        public Builder offset(Integer offset) {
            assert (offset >= 0);
            return (Builder)this.setQueryParameter("offset", offset);
        }

        public Builder market(CountryCode market) {
            assert (market != null);
            return (Builder)this.setQueryParameter("market", market);
        }

        public GetCurrentUsersSavedAlbumsRequest build() {
            this.setPath("/v1/me/albums");
            return new GetCurrentUsersSavedAlbumsRequest(this);
        }
    }
}

