/*
 * Decompiled with CFR 0.152.
 */
package com.wrapper.spotify.requests.data.player;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.wrapper.spotify.SpotifyApi;
import com.wrapper.spotify.exceptions.SpotifyWebApiException;
import com.wrapper.spotify.model_objects.specification.PagingCursorbased;
import com.wrapper.spotify.model_objects.specification.PlayHistory;
import com.wrapper.spotify.requests.data.AbstractDataPagingCursorbasedRequest;
import com.wrapper.spotify.requests.data.AbstractDataRequest;
import java.io.IOException;
import java.util.Date;

@JsonDeserialize(builder=Builder.class)
public class GetCurrentUsersRecentlyPlayedTracksRequest
extends AbstractDataRequest<PagingCursorbased<PlayHistory>> {
    private GetCurrentUsersRecentlyPlayedTracksRequest(Builder builder) {
        super(builder);
    }

    @Override
    public PagingCursorbased<PlayHistory> execute() throws IOException, SpotifyWebApiException {
        return new PlayHistory.JsonUtil().createModelObjectPagingCursorbased(this.getJson());
    }

    public static final class Builder
    extends AbstractDataPagingCursorbasedRequest.Builder<PlayHistory, Date, Builder> {
        public Builder(String accessToken) {
            super(accessToken);
        }

        @Override
        public Builder limit(Integer limit) {
            assert (limit != null);
            assert (1 <= limit && limit <= 50);
            return (Builder)this.setQueryParameter("limit", limit);
        }

        @Override
        public Builder after(Date after) {
            assert (after != null);
            return (Builder)this.setQueryParameter("after", SpotifyApi.formatDefaultDate(after));
        }

        public Builder before(Date before) {
            assert (before != null);
            return (Builder)this.setQueryParameter("before", SpotifyApi.formatDefaultDate(before));
        }

        public GetCurrentUsersRecentlyPlayedTracksRequest build() {
            this.setPath("/v1/me/player/recently-played");
            return new GetCurrentUsersRecentlyPlayedTracksRequest(this);
        }
    }
}

