/*
 * Decompiled with CFR 0.152.
 */
package com.wrapper.spotify.requests.data.playlists;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.wrapper.spotify.exceptions.SpotifyWebApiException;
import com.wrapper.spotify.model_objects.specification.Playlist;
import com.wrapper.spotify.requests.data.AbstractDataRequest;
import java.io.IOException;
import org.apache.http.entity.ContentType;

@JsonDeserialize(builder=Builder.class)
public class CreatePlaylistRequest
extends AbstractDataRequest<Playlist> {
    private CreatePlaylistRequest(Builder builder) {
        super(builder);
    }

    @Override
    public Playlist execute() throws IOException, SpotifyWebApiException {
        return (Playlist)new Playlist.JsonUtil().createModelObject(this.postJson());
    }

    public static final class Builder
    extends AbstractDataRequest.Builder<Playlist, Builder> {
        public Builder(String accessToken) {
            super(accessToken);
        }

        public Builder user_id(String user_id) {
            assert (user_id != null);
            assert (!user_id.equals(""));
            return (Builder)this.setPathParameter("user_id", user_id);
        }

        public Builder name(String name) {
            assert (name != null);
            assert (!name.equals(""));
            return (Builder)this.setBodyParameter("name", name);
        }

        public Builder public_(Boolean public_) {
            return (Builder)this.setBodyParameter("public", public_);
        }

        public Builder collaborative(Boolean collaborative) {
            return (Builder)this.setBodyParameter("collaborative", collaborative);
        }

        public Builder description(String description) {
            assert (description != null);
            assert (!description.equals(""));
            return (Builder)this.setBodyParameter("description", description);
        }

        public CreatePlaylistRequest build() {
            this.setContentType(ContentType.APPLICATION_JSON);
            this.setPath("/v1/users/{user_id}/playlists");
            return new CreatePlaylistRequest(this);
        }
    }
}

