/*
 * Decompiled with CFR 0.152.
 */
package com.wrapper.spotify.requests.data.playlists;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.wrapper.spotify.exceptions.SpotifyWebApiException;
import com.wrapper.spotify.model_objects.specification.Paging;
import com.wrapper.spotify.model_objects.specification.PlaylistSimplified;
import com.wrapper.spotify.requests.data.AbstractDataPagingRequest;
import com.wrapper.spotify.requests.data.AbstractDataRequest;
import java.io.IOException;

@JsonDeserialize(builder=Builder.class)
public class GetListOfUsersPlaylistsRequest
extends AbstractDataRequest<Paging<PlaylistSimplified>> {
    private GetListOfUsersPlaylistsRequest(Builder builder) {
        super(builder);
    }

    @Override
    public Paging<PlaylistSimplified> execute() throws IOException, SpotifyWebApiException {
        return new PlaylistSimplified.JsonUtil().createModelObjectPaging(this.getJson());
    }

    public static final class Builder
    extends AbstractDataPagingRequest.Builder<PlaylistSimplified, Builder> {
        public Builder(String accessToken) {
            super(accessToken);
        }

        public Builder user_id(String user_id) {
            assert (user_id != null);
            assert (!user_id.equals(""));
            return (Builder)this.setPathParameter("user_id", user_id);
        }

        @Override
        public Builder limit(Integer limit) {
            assert (1 <= limit && limit <= 50);
            return (Builder)this.setQueryParameter("limit", limit);
        }

        @Override
        public Builder offset(Integer offset) {
            assert (0 <= offset && offset <= 100000);
            return (Builder)this.setQueryParameter("offset", offset);
        }

        public GetListOfUsersPlaylistsRequest build() {
            this.setPath("/v1/users/{user_id}/playlists");
            return new GetListOfUsersPlaylistsRequest(this);
        }
    }
}

