/*
 * Decompiled with CFR 0.152.
 */
package com.wrapper.spotify.requests.data.playlists;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.neovisionaries.i18n.CountryCode;
import com.wrapper.spotify.exceptions.SpotifyWebApiException;
import com.wrapper.spotify.model_objects.specification.Paging;
import com.wrapper.spotify.model_objects.specification.PlaylistTrack;
import com.wrapper.spotify.requests.data.AbstractDataPagingRequest;
import com.wrapper.spotify.requests.data.AbstractDataRequest;
import java.io.IOException;

@JsonDeserialize(builder=Builder.class)
public class GetPlaylistsTracksRequest
extends AbstractDataRequest<Paging<PlaylistTrack>> {
    private GetPlaylistsTracksRequest(Builder builder) {
        super(builder);
    }

    @Override
    public Paging<PlaylistTrack> execute() throws IOException, SpotifyWebApiException {
        return new PlaylistTrack.JsonUtil().createModelObjectPaging(this.getJson());
    }

    public static final class Builder
    extends AbstractDataPagingRequest.Builder<PlaylistTrack, Builder> {
        public Builder(String accessToken) {
            super(accessToken);
        }

        @Deprecated
        public Builder user_id(String user_id) {
            assert (user_id != null);
            assert (!user_id.equals(""));
            return (Builder)this.setPathParameter("user_id", user_id);
        }

        public Builder playlist_id(String playlist_id) {
            assert (playlist_id != null);
            assert (!playlist_id.equals(""));
            return (Builder)this.setPathParameter("playlist_id", playlist_id);
        }

        public Builder fields(String fields) {
            assert (fields != null);
            assert (!fields.equals(""));
            return (Builder)this.setQueryParameter("fields", fields);
        }

        @Override
        public Builder limit(Integer limit) {
            assert (1 <= limit && limit <= 100);
            return (Builder)this.setQueryParameter("limit", limit);
        }

        @Override
        public Builder offset(Integer offset) {
            assert (offset >= 0);
            return (Builder)this.setQueryParameter("offset", offset);
        }

        public Builder market(CountryCode market) {
            assert (market != null);
            return (Builder)this.setQueryParameter("market", market);
        }

        public GetPlaylistsTracksRequest build() {
            this.setPath("/v1/playlists/{playlist_id}/tracks");
            return new GetPlaylistsTracksRequest(this);
        }
    }
}

