/*
 * Decompiled with CFR 0.152.
 */
package com.wrapper.spotify.requests.data.playlists;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.wrapper.spotify.exceptions.SpotifyWebApiException;
import com.wrapper.spotify.requests.data.AbstractDataRequest;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;

@JsonDeserialize(builder=Builder.class)
public class UploadCustomPlaylistCoverImageRequest
extends AbstractDataRequest<String> {
    private UploadCustomPlaylistCoverImageRequest(Builder builder) {
        super(builder);
    }

    @Override
    public String execute() throws IOException, SpotifyWebApiException {
        return this.putJson();
    }

    public static final class Builder
    extends AbstractDataRequest.Builder<String, Builder> {
        public Builder(String accessToken) {
            super(accessToken);
        }

        @Deprecated
        public Builder user_id(String user_id) {
            assert (user_id != null);
            assert (!user_id.equals(""));
            return (Builder)this.setPathParameter("user_id", user_id);
        }

        public Builder playlist_id(String playlist_id) {
            assert (playlist_id != null);
            assert (!playlist_id.equals(""));
            return (Builder)this.setPathParameter("playlist_id", playlist_id);
        }

        public Builder image_data(String image_data) {
            assert (image_data != null);
            assert (!image_data.equals(""));
            assert (image_data.getBytes().length <= 256000);
            return (Builder)this.setBody((HttpEntity)new StringEntity(image_data, ContentType.IMAGE_JPEG));
        }

        public UploadCustomPlaylistCoverImageRequest build() {
            this.setContentType(ContentType.IMAGE_JPEG);
            this.setPath("/v1/playlists/{playlist_id}/images");
            return new UploadCustomPlaylistCoverImageRequest(this);
        }
    }
}

