/*
 * Decompiled with CFR 0.152.
 */
package com.wrapper.spotify.requests.data.search.simplified;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.neovisionaries.i18n.CountryCode;
import com.wrapper.spotify.exceptions.SpotifyWebApiException;
import com.wrapper.spotify.model_objects.specification.Paging;
import com.wrapper.spotify.model_objects.specification.Track;
import com.wrapper.spotify.requests.data.AbstractDataPagingRequest;
import com.wrapper.spotify.requests.data.AbstractDataRequest;
import java.io.IOException;

@JsonDeserialize(builder=Builder.class)
public class SearchTracksRequest
extends AbstractDataRequest<Paging<Track>> {
    private SearchTracksRequest(Builder builder) {
        super(builder);
    }

    @Override
    public Paging<Track> execute() throws IOException, SpotifyWebApiException {
        return new Track.JsonUtil().createModelObjectPaging(this.getJson(), "tracks");
    }

    public static final class Builder
    extends AbstractDataPagingRequest.Builder<Track, Builder> {
        public Builder(String accessToken) {
            super(accessToken);
        }

        public Builder q(String q) {
            assert (q != null);
            assert (!q.equals(""));
            return (Builder)this.setQueryParameter("q", q);
        }

        public Builder market(CountryCode market) {
            assert (market != null);
            return (Builder)this.setQueryParameter("market", market);
        }

        @Override
        public Builder limit(Integer limit) {
            assert (limit != null);
            assert (1 <= limit && limit <= 50);
            return (Builder)this.setQueryParameter("limit", limit);
        }

        @Override
        public Builder offset(Integer offset) {
            assert (offset != null);
            assert (0 <= offset && offset <= 100000);
            return (Builder)this.setQueryParameter("offset", offset);
        }

        public SearchTracksRequest build() {
            this.setPath("/v1/search");
            this.setQueryParameter("type", "track");
            return new SearchTracksRequest(this);
        }
    }
}

