/*
 * Decompiled with CFR 0.152.
 */
package com.wrapper.spotify.requests.data.tracks;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.neovisionaries.i18n.CountryCode;
import com.wrapper.spotify.exceptions.SpotifyWebApiException;
import com.wrapper.spotify.model_objects.specification.Track;
import com.wrapper.spotify.requests.data.AbstractDataRequest;
import java.io.IOException;

@JsonDeserialize(builder=Builder.class)
public class GetSeveralTracksRequest
extends AbstractDataRequest<Track[]> {
    private GetSeveralTracksRequest(Builder builder) {
        super(builder);
    }

    @Override
    public Track[] execute() throws IOException, SpotifyWebApiException {
        return (Track[])new Track.JsonUtil().createModelObjectArray(this.getJson(), "tracks");
    }

    public static final class Builder
    extends AbstractDataRequest.Builder<Track[], Builder> {
        public Builder(String accessToken) {
            super(accessToken);
        }

        public Builder ids(String ids) {
            assert (ids != null);
            assert (ids.split(",").length <= 50);
            return (Builder)this.setQueryParameter("ids", ids);
        }

        public Builder market(CountryCode market) {
            assert (market != null);
            return (Builder)this.setQueryParameter("market", market);
        }

        public GetSeveralTracksRequest build() {
            this.setPath("/v1/tracks");
            return new GetSeveralTracksRequest(this);
        }
    }
}

