/*
 * Decompiled with CFR 0.152.
 */
package se.signatureservice.configuration.common.utils;

import java.awt.Color;

public class ColorParser {
    public static Color parse(String colorHex) throws NumberFormatException {
        Color color;
        if (colorHex == null) {
            throw new NumberFormatException("Cannot parse null");
        }
        if (colorHex.startsWith("#")) {
            colorHex = colorHex.substring(1);
        }
        if (colorHex.length() != 6 && colorHex.length() != 8) {
            throw new NumberFormatException("Input has invalid length");
        }
        try {
            int r = Integer.parseInt(colorHex.substring(0, 2), 16);
            int g = Integer.parseInt(colorHex.substring(2, 4), 16);
            int b = Integer.parseInt(colorHex.substring(4, 6), 16);
            int a = colorHex.length() == 6 ? 255 : Integer.parseInt(colorHex.substring(6, 8), 16);
            color = new Color(r, g, b, a);
        }
        catch (Exception e) {
            throw new NumberFormatException("Cannot parse input: ${e.message}");
        }
        return color;
    }
}

