/*
 * Decompiled with CFR 0.152.
 */
package se.signatureservice.configuration.common.utils;

import java.util.List;
import java.util.Map;
import se.signatureservice.configuration.common.InternalErrorException;
import se.signatureservice.configuration.common.InvalidArgumentException;

public class ConfigUtils {
    public static Integer parseInteger(Object value, String errorMessage) throws InternalErrorException {
        return ConfigUtils.parseInteger(value, errorMessage, false, null);
    }

    public static Integer parseInteger(Object value, String errorMessage, boolean required, Integer defaultValue) throws InternalErrorException {
        block5: {
            if (value instanceof Integer) {
                return (Integer)value;
            }
            try {
                if (!(value instanceof String)) break block5;
                if (((String)value).isEmpty()) {
                    value = null;
                    break block5;
                }
                return Integer.parseInt((String)value);
            }
            catch (Exception e) {
                throw new InternalErrorException(errorMessage, e);
            }
        }
        if (ConfigUtils.isNullOrEmptyMap(value) && !required) {
            return defaultValue;
        }
        throw new InternalErrorException(errorMessage);
    }

    public static Boolean parseBoolean(Object value, String errorMessage) throws InternalErrorException {
        return ConfigUtils.parseBoolean(value, errorMessage, false, null);
    }

    public static Boolean parseBoolean(Object value, String errorMessage, boolean required, Boolean defaultValue) throws InternalErrorException {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            if (((String)value).isEmpty()) {
                value = null;
            } else {
                String s = ((String)value).toLowerCase().trim();
                if (s.equals("true")) {
                    return true;
                }
                if (s.equals("false")) {
                    return false;
                }
                throw new InternalErrorException(errorMessage);
            }
        }
        if (ConfigUtils.isNullOrEmptyMap(value) && !required) {
            return defaultValue;
        }
        throw new InternalErrorException(errorMessage);
    }

    public static String parseString(Object value, String errorMessage) throws InternalErrorException {
        return ConfigUtils.parseString(value, errorMessage, false, null);
    }

    public static String parseString(Object value, String errorMessage, boolean required) throws InternalErrorException {
        return ConfigUtils.parseString(value, errorMessage, required, null);
    }

    public static String parseString(Object value, String errorMessage, boolean required, String defaultValue) throws InternalErrorException {
        if (value instanceof String) {
            if (!((String)value).trim().isEmpty()) {
                return (String)value;
            }
        } else if (ConfigUtils.isNullOrEmptyMap(value) && !required) {
            return defaultValue;
        }
        throw new InternalErrorException(errorMessage);
    }

    public static Float parseFloat(Object value, String errorMessage, boolean required, Float defaultValue) throws InternalErrorException {
        block7: {
            if (value instanceof Float) {
                return (Float)value;
            }
            if (value instanceof Long) {
                return Float.valueOf(((Long)value).floatValue());
            }
            if (value instanceof Integer) {
                return Float.valueOf(((Integer)value).floatValue());
            }
            try {
                if (!(value instanceof String)) break block7;
                if (((String)value).isEmpty()) {
                    value = null;
                    break block7;
                }
                return Float.valueOf(Float.parseFloat((String)value));
            }
            catch (Exception e) {
                throw new InternalErrorException(errorMessage, e);
            }
        }
        if (ConfigUtils.isNullOrEmptyMap(value) && !required) {
            return defaultValue;
        }
        throw new InternalErrorException(errorMessage);
    }

    public static Long parseLong(Object value, String errorMessage) throws InternalErrorException {
        return ConfigUtils.parseLong(value, errorMessage, false, null);
    }

    public static Long parseLong(Object value, String errorMessage, boolean required) throws InternalErrorException {
        return ConfigUtils.parseLong(value, errorMessage, required, null);
    }

    public static Long parseLong(Object value, String errorMessage, boolean required, Long defaultValue) throws InternalErrorException {
        block6: {
            if (value instanceof Integer) {
                return ((Integer)value).longValue();
            }
            if (value instanceof Long) {
                return (Long)value;
            }
            try {
                if (!(value instanceof String)) break block6;
                if (((String)value).isEmpty()) {
                    value = null;
                    break block6;
                }
                return Long.parseLong((String)value);
            }
            catch (Exception e) {
                throw new InternalErrorException(errorMessage, e);
            }
        }
        if (ConfigUtils.isNullOrEmptyMap(value) && !required) {
            return defaultValue;
        }
        throw new InternalErrorException(errorMessage);
    }

    public static List<String> parseListOfString(Object value, String errorMessage) throws InternalErrorException {
        return ConfigUtils.parseListOfString(value, errorMessage, false);
    }

    public static List<String> parseListOfString(Object value, String errorMessage, boolean required) throws InternalErrorException {
        if (value instanceof List) {
            List list = (List)value;
            if (list.isEmpty() && required) {
                throw new InternalErrorException(errorMessage);
            }
            for (Object item : list) {
                if (item == null) {
                    throw new InternalErrorException(errorMessage);
                }
                if (item instanceof String && !((String)item).trim().isEmpty()) continue;
                throw new InternalErrorException(errorMessage);
            }
            return list;
        }
        if (ConfigUtils.isNullOrEmptyMap(value) && !required) {
            return null;
        }
        throw new InternalErrorException(errorMessage);
    }

    public static boolean isNullOrEmptyMap(Object value) {
        return value == null || value instanceof Map && ((Map)value).isEmpty();
    }

    public static String getKeyStoreExtension(String type, String filePrefix) throws InvalidArgumentException {
        if (type == null && filePrefix != null) {
            if (filePrefix.equalsIgnoreCase("p12") || filePrefix.equalsIgnoreCase("pfx")) {
                type = "PKCS12";
            } else if (filePrefix.equalsIgnoreCase("jks")) {
                type = "JKS";
            } else {
                throw new InvalidArgumentException("Unsupported truststore filename extension: ${trustStorePrefix}");
            }
        }
        return type;
    }
}

