/*
 * Decompiled with CFR 0.152.
 */
package se.signatureservice.configuration.support.system;

import java.util.Map;
import se.signatureservice.configuration.common.InternalErrorException;
import se.signatureservice.configuration.common.utils.ConfigUtils;

public class VisibleSignatureConfig {
    private static final boolean DEFAULT_ENABLE = false;
    private static final String DEFAULT_FONT = null;
    private static final boolean DEFAULT_SHOW_LOGO = true;
    private static final boolean DEFAULT_SHOW_HEADLINE = true;
    boolean enable = false;
    String font = DEFAULT_FONT;
    float fontSize = 9.0f;
    String fontColor = "#000000";
    String backgroundColor = "#ffffff";
    boolean showLogo = true;
    String logoImage = "/visibleSignatures/Default_Logo.png";
    boolean showHeadline = true;
    String headlineText = "Document Digital Signed";
    String signerLabel = "Signer";
    String timeStampLabel = "Time";
    String timeStampFormat = "yyyy-MM-dd HH:mm:ss";
    String signatureTextTemplate = null;
    float textPadding = 50.0f;

    public VisibleSignatureConfig() {
    }

    public VisibleSignatureConfig(Map<String, String> config) throws InternalErrorException {
        if (config != null) {
            String colorHex;
            this.enable = ConfigUtils.parseBoolean(config.get("enable"), "Invalid value for 'enable' in visibleSignature configuration", false, false);
            this.font = ConfigUtils.parseString(config.get("font"), "Invalid value for 'font' in visibleSignature configuration", false, DEFAULT_FONT);
            this.fontSize = ConfigUtils.parseFloat(config.get("fontSize"), "Invalid value for 'fontSize' in visibleSignature configuration", false, Float.valueOf(this.fontSize)).floatValue();
            this.showLogo = ConfigUtils.parseBoolean(config.get("showLogo"), "Invalid value for 'showLogo' in visibleSignature configuration", false, true);
            this.logoImage = ConfigUtils.parseString(config.get("logoImage"), "Invalid value for 'logoImage' in visibleSignature configuration", false, this.logoImage);
            this.showHeadline = ConfigUtils.parseBoolean(config.get("showHeadline"), "Invalid value for 'showHeadline' in visibleSignature configuration", false, true);
            this.headlineText = ConfigUtils.parseString(config.get("headlineText"), "Invalid value for 'headlineText' in visibleSignature configuration", false, this.headlineText);
            this.signerLabel = ConfigUtils.parseString(config.get("signerLabel"), "Invalid value for 'signerLabel' in visibleSignature configuration", false, this.signerLabel);
            this.timeStampLabel = ConfigUtils.parseString(config.get("timeStampLabel"), "Invalid value for 'timeStampLabel' in visibleSignature configuration", false, this.timeStampLabel);
            this.timeStampFormat = ConfigUtils.parseString(config.get("timeStampFormat"), "Invalid value for 'timeStampFormat' in visibleSignature configuration", false, this.timeStampFormat);
            this.textPadding = ConfigUtils.parseFloat(config.get("textPadding"), "Invalid value for 'textPadding' in visibleSignature configuration", false, Float.valueOf(this.textPadding)).floatValue();
            this.signatureTextTemplate = ConfigUtils.parseString(config.get("signatureTextTemplate"), "Invalid value for 'signatureTextTemplate' in visibleSignature configuration", false, this.signatureTextTemplate);
            try {
                colorHex = ConfigUtils.parseString(config.get("fontColor"), "Invalid value for 'fontColor' in visibleSignature configuration", false, null);
                if (colorHex != null) {
                    this.fontColor = colorHex;
                }
            }
            catch (Exception e) {
                throw new InternalErrorException("Invalid color specified for 'fontColor' in visibleSignature configuration: ${e.message}");
            }
            try {
                colorHex = ConfigUtils.parseString(config.get("backgroundColor"), "Invalid value for 'backgroundColor' in visibleSignature configuration", false, null);
                if (colorHex != null) {
                    this.backgroundColor = colorHex;
                }
            }
            catch (Exception e) {
                throw new InternalErrorException("Invalid color specified for 'backgroundColor' in visibleSignature configuration: ${e.message}");
            }
        }
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public String getFont() {
        return this.font;
    }

    public void setFont(String font) {
        this.font = font;
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(float fontSize) {
        this.fontSize = fontSize;
    }

    public String getFontColor() {
        return this.fontColor;
    }

    public void setFontColor(String fontColor) {
        this.fontColor = fontColor;
    }

    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public boolean isShowLogo() {
        return this.showLogo;
    }

    public void setShowLogo(boolean showLogo) {
        this.showLogo = showLogo;
    }

    public String getLogoImage() {
        return this.logoImage;
    }

    public void setLogoImage(String logoImage) {
        this.logoImage = logoImage;
    }

    public boolean isShowHeadline() {
        return this.showHeadline;
    }

    public void setShowHeadline(boolean showHeadline) {
        this.showHeadline = showHeadline;
    }

    public String getHeadlineText() {
        return this.headlineText;
    }

    public void setHeadlineText(String headlineText) {
        this.headlineText = headlineText;
    }

    public String getSignerLabel() {
        return this.signerLabel;
    }

    public void setSignerLabel(String signerLabel) {
        this.signerLabel = signerLabel;
    }

    public String getTimeStampLabel() {
        return this.timeStampLabel;
    }

    public void setTimeStampLabel(String timeStampLabel) {
        this.timeStampLabel = timeStampLabel;
    }

    public String getTimeStampFormat() {
        return this.timeStampFormat;
    }

    public void setTimeStampFormat(String timeStampFormat) {
        this.timeStampFormat = timeStampFormat;
    }

    public float getTextPadding() {
        return this.textPadding;
    }

    public void setTextPadding(float textPadding) {
        this.textPadding = textPadding;
    }

    public String getSignatureTextTemplate() {
        return this.signatureTextTemplate;
    }

    public void setSignatureTextTemplate(String template) {
        this.signatureTextTemplate = template;
    }
}

