/*
 * Decompiled with CFR 0.152.
 */
package se.softhouse.jargo.addons;

import java.util.Locale;
import java.util.Objects;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import se.softhouse.jargo.ArgumentException;
import se.softhouse.jargo.ArgumentExceptions;
import se.softhouse.jargo.StringParser;

final class DateTimeParser
implements StringParser<DateTime> {
    private final DateTimeZone timeZone;
    private final DateTimeFormatter formatter;

    DateTimeParser(DateTimeZone timeZone) {
        this.timeZone = Objects.requireNonNull(timeZone);
        this.formatter = ISODateTimeFormat.dateOptionalTimeParser().withZone(timeZone);
    }

    public String descriptionOfValidValues(Locale locale) {
        Objects.requireNonNull(locale);
        String unmistakableDate = new DateTime((Object)"2011-02-28", this.timeZone).toString(ISODateTimeFormat.dateTime());
        return "an ISO8601 date, such as " + unmistakableDate;
    }

    public DateTime parse(String value, Locale locale) throws ArgumentException {
        Objects.requireNonNull(locale);
        try {
            return DateTime.parse((String)value, (DateTimeFormatter)this.formatter);
        }
        catch (IllegalArgumentException wrongDateFormat) {
            throw ArgumentExceptions.withMessage((Object)wrongDateFormat.getLocalizedMessage());
        }
    }

    public DateTime defaultValue() {
        return DateTime.now((DateTimeZone)this.timeZone);
    }

    public String metaDescription() {
        return "<date>";
    }
}

