/*
 * Decompiled with CFR 0.152.
 */
package se.swedenconnect.security.algorithms;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.RSASSAPSSparams;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import se.swedenconnect.security.algorithms.Algorithm;
import se.swedenconnect.security.algorithms.AlgorithmIdentifierAware;
import se.swedenconnect.security.algorithms.AlgorithmType;
import se.swedenconnect.security.algorithms.KeyBasedAlgorithm;

public class AlgorithmPredicates {
    public static Predicate<Algorithm> notBlacklisted() {
        return a -> !a.isBlacklisted();
    }

    public static Predicate<Algorithm> fromJcaName(String jcaName) {
        return a -> Objects.equals(a.getJcaName(), jcaName);
    }

    public static Predicate<Algorithm> fromType(AlgorithmType type) {
        return a -> a.getType().equals((Object)type);
    }

    public static Predicate<Algorithm> fromKeyType(String keyType) {
        return a -> KeyBasedAlgorithm.class.isInstance(a) && Objects.equals(((KeyBasedAlgorithm)KeyBasedAlgorithm.class.cast(a)).getKeyType(), keyType);
    }

    public static Predicate<Algorithm> fromAlgorithmIdentifier(AlgorithmIdentifier algorithmIdentifier) {
        return a -> AlgorithmIdentifierAware.class.isInstance(a) && Objects.equals(((AlgorithmIdentifierAware)AlgorithmIdentifierAware.class.cast(a)).getAlgorithmIdentifier(), algorithmIdentifier);
    }

    public static Predicate<Algorithm> fromAlgorithmIdentifierRelaxed(AlgorithmIdentifier algorithmIdentifier) {
        return algorithm -> {
            if (!AlgorithmIdentifierAware.class.isInstance(algorithm)) {
                return false;
            }
            AlgorithmIdentifier ai = ((AlgorithmIdentifierAware)AlgorithmIdentifierAware.class.cast(algorithm)).getAlgorithmIdentifier();
            if (ai == null) {
                return false;
            }
            if (algorithmIdentifier.getParameters() == null) {
                return Objects.equals(algorithmIdentifier.getAlgorithm(), ai.getAlgorithm());
            }
            if (algorithmIdentifier.getAlgorithm().equals((ASN1Primitive)PKCSObjectIdentifiers.id_RSASSA_PSS)) {
                if (!ai.getAlgorithm().equals((ASN1Primitive)PKCSObjectIdentifiers.id_RSASSA_PSS)) {
                    return false;
                }
                return Objects.equals(Optional.ofNullable(algorithmIdentifier.getParameters()).map(p -> RSASSAPSSparams.getInstance((Object)p)).map(RSASSAPSSparams::getHashAlgorithm).map(AlgorithmIdentifier::getAlgorithm).orElse(null), Optional.ofNullable(ai.getParameters()).map(p -> RSASSAPSSparams.getInstance((Object)p)).map(RSASSAPSSparams::getHashAlgorithm).map(AlgorithmIdentifier::getAlgorithm).orElse(null));
            }
            return algorithmIdentifier.equals((Object)((AlgorithmIdentifierAware)AlgorithmIdentifierAware.class.cast(algorithm)).getAlgorithmIdentifier());
        };
    }

    private AlgorithmPredicates() {
    }
}

