/*
 * Decompiled with CFR 0.152.
 */
package se.swedenconnect.security.algorithms;

import java.util.List;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.swedenconnect.security.algorithms.Algorithm;
import se.swedenconnect.security.algorithms.AlgorithmRegistry;
import se.swedenconnect.security.algorithms.impl.StaticAlgorithmRegistry;

public class AlgorithmRegistrySingleton
implements AlgorithmRegistry {
    private static final Logger log = LoggerFactory.getLogger(AlgorithmRegistrySingleton.class);
    private static final AlgorithmRegistrySingleton instance = new AlgorithmRegistrySingleton();
    private AlgorithmRegistry registry;

    private AlgorithmRegistrySingleton() {
    }

    public static AlgorithmRegistrySingleton getInstance() {
        return instance;
    }

    public static void setAlgorithmRegistry(AlgorithmRegistry algorithmRegistry) {
        if (AlgorithmRegistrySingleton.instance.registry != null) {
            throw new SecurityException("Cannot assign algorithm registry to AlgorithmRegistrySingleton - it has already been initialized");
        }
        AlgorithmRegistrySingleton.instance.registry = algorithmRegistry;
    }

    @Override
    public Algorithm getAlgorithm(String algorithmUri) {
        return this.getAlgorithmRegistry().getAlgorithm(algorithmUri);
    }

    @Override
    public <T extends Algorithm> T getAlgorithm(String algorithmUri, Class<T> clazz) {
        return this.getAlgorithmRegistry().getAlgorithm(algorithmUri, clazz);
    }

    @Override
    public Algorithm getAlgorithm(Predicate<Algorithm> predicate) {
        return this.getAlgorithmRegistry().getAlgorithm(predicate);
    }

    @Override
    public <T extends Algorithm> T getAlgorithm(Predicate<Algorithm> predicate, Class<T> clazz) {
        return this.getAlgorithmRegistry().getAlgorithm(predicate, clazz);
    }

    @Override
    public List<Algorithm> getAlgorithms(Predicate<Algorithm> predicate) {
        return this.getAlgorithmRegistry().getAlgorithms(predicate);
    }

    @Override
    public <T extends Algorithm> List<T> getAlgorithms(Predicate<Algorithm> predicate, Class<T> clazz) {
        return this.getAlgorithmRegistry().getAlgorithms(predicate, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AlgorithmRegistry getAlgorithmRegistry() {
        if (this.registry == null) {
            log.info("Registry not initialized - using default implementation ...");
            AlgorithmRegistrySingleton algorithmRegistrySingleton = this;
            synchronized (algorithmRegistrySingleton) {
                this.registry = new StaticAlgorithmRegistry();
            }
        }
        return this.registry;
    }
}

