/*
 * Decompiled with CFR 0.152.
 */
package se.swedenconnect.security.algorithms.curves;

import java.util.Objects;

public class NamedCurve {
    private final String name;
    private final String objectIdentifier;
    private final int keyLength;

    public NamedCurve(String name, String objectIdentifier, int keyLength) {
        this.name = Objects.requireNonNull(name, "name must not be null");
        this.objectIdentifier = Objects.requireNonNull(objectIdentifier, "objectIdentifier must not be null");
        this.keyLength = keyLength;
    }

    public String getName() {
        return this.name;
    }

    public String getObjectIdentifier() {
        return this.objectIdentifier;
    }

    public String getUri() {
        return "urn:oid:" + this.objectIdentifier;
    }

    public int getKeyLength() {
        return this.keyLength;
    }

    public int hashCode() {
        return Objects.hash(this.keyLength, this.name, this.objectIdentifier);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof NamedCurve)) {
            return false;
        }
        NamedCurve other = (NamedCurve)obj;
        return this.keyLength == other.keyLength && Objects.equals(this.name, other.name) && Objects.equals(this.objectIdentifier, other.objectIdentifier);
    }

    public String toString() {
        return String.format("name='%s', object-identifier='%s', uri='%s', key-length=%d", this.name, this.objectIdentifier, this.getUri(), this.keyLength);
    }
}

