/*
 * Decompiled with CFR 0.152.
 */
package se.swedenconnect.security.algorithms.curves;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.swedenconnect.security.algorithms.curves.NamedCurve;
import se.swedenconnect.security.algorithms.curves.NamedCurveRegistry;

public class NamedCurveRegistryImpl
implements NamedCurveRegistry {
    private static final Logger log = LoggerFactory.getLogger(NamedCurveRegistryImpl.class);
    private final Map<String, NamedCurve> registry = new ConcurrentHashMap<String, NamedCurve>();

    public NamedCurveRegistryImpl() {
    }

    public NamedCurveRegistryImpl(List<NamedCurve> registry) {
        this();
        if (registry != null) {
            registry.forEach(c -> this.register((NamedCurve)c));
        }
    }

    public void register(NamedCurve curve) {
        log.debug("Registering curve: {}", (Object)curve);
        this.registry.put(curve.getName(), curve);
    }

    public void unregister(String name) {
        NamedCurve curve = this.registry.remove(name);
        if (curve != null) {
            log.debug("Algorithm '{}' was removed from the registry", (Object)name);
        }
    }

    @Override
    public NamedCurve getCurve(String name) {
        return this.registry.get(name);
    }

    @Override
    public NamedCurve getCurve(Predicate<NamedCurve> predicate) {
        return this.registry.values().stream().filter(predicate).findFirst().orElse(null);
    }

    @Override
    public List<NamedCurve> getCurves(Predicate<NamedCurve> predicate) {
        return this.registry.values().stream().filter(predicate).collect(Collectors.toList());
    }
}

