/*
 * Decompiled with CFR 0.152.
 */
package se.swedenconnect.security.algorithms.curves;

import java.util.List;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.swedenconnect.security.algorithms.curves.NamedCurve;
import se.swedenconnect.security.algorithms.curves.NamedCurveRegistry;
import se.swedenconnect.security.algorithms.curves.StaticNamedCurveRegistry;

public class NamedCurveRegistrySingleton
implements NamedCurveRegistry {
    private static final Logger log = LoggerFactory.getLogger(NamedCurveRegistrySingleton.class);
    private static final NamedCurveRegistrySingleton instance = new NamedCurveRegistrySingleton();
    private NamedCurveRegistry registry;

    private NamedCurveRegistrySingleton() {
    }

    public static NamedCurveRegistrySingleton getInstance() {
        return instance;
    }

    public static void setAlgorithmRegistry(NamedCurveRegistry registry) {
        if (NamedCurveRegistrySingleton.instance.registry != null) {
            throw new SecurityException("Cannot assign named curve registry to NamedCurveRegistrySingleton - it has already been initialized");
        }
        NamedCurveRegistrySingleton.instance.registry = registry;
    }

    @Override
    public NamedCurve getCurve(String name) {
        return this.getNamedCurveRegistry().getCurve(name);
    }

    @Override
    public NamedCurve getCurve(Predicate<NamedCurve> predicate) {
        return this.getNamedCurveRegistry().getCurve(predicate);
    }

    @Override
    public List<NamedCurve> getCurves(Predicate<NamedCurve> predicate) {
        return this.getNamedCurveRegistry().getCurves(predicate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NamedCurveRegistry getNamedCurveRegistry() {
        if (this.registry == null) {
            log.info("Registry not initialized - using default implementation ...");
            NamedCurveRegistrySingleton namedCurveRegistrySingleton = this;
            synchronized (namedCurveRegistrySingleton) {
                this.registry = new StaticNamedCurveRegistry();
            }
        }
        return this.registry;
    }
}

