/*
 * Decompiled with CFR 0.152.
 */
package se.swedenconnect.security.algorithms.impl;

import java.util.Objects;
import se.swedenconnect.security.algorithms.Algorithm;
import se.swedenconnect.security.algorithms.impl.AlgorithmBuilder;

public abstract class AbstractAlgorithm
implements Algorithm {
    private final String uri;
    private String jcaName;
    private int order = Integer.MAX_VALUE;
    private boolean blacklisted = false;

    public AbstractAlgorithm(String uri, int order, String jcaName) {
        this.uri = Objects.requireNonNull(uri, "The algorithm uri must be set");
        this.setOrder(order);
        this.setJcaName(jcaName);
    }

    protected AbstractAlgorithm(String uri) {
        this.uri = Objects.requireNonNull(uri, "The algorithm uri must be set");
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    @Override
    public String getJcaName() {
        return this.jcaName;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    protected void setJcaName(String jcaName) {
        this.jcaName = Objects.requireNonNull(jcaName, "The algorithm JCA name must be set");
    }

    protected void setOrder(int order) {
        if (order < 1) {
            throw new IllegalArgumentException("Order must be greater than 0");
        }
        this.order = order;
    }

    @Override
    public boolean isBlacklisted() {
        return this.blacklisted;
    }

    public void setBlacklisted(boolean blacklisted) {
        this.blacklisted = blacklisted;
    }

    public int hashCode() {
        return Objects.hash(this.jcaName, this.uri);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AbstractAlgorithm)) {
            return false;
        }
        AbstractAlgorithm other = (AbstractAlgorithm)obj;
        return Objects.equals(this.jcaName, other.jcaName) && Objects.equals(this.uri, other.uri);
    }

    public String toString() {
        return String.format("uri='%s', jca-name='%s', order='%d', blacklisted='%s'", this.uri, this.jcaName, this.order, this.blacklisted);
    }

    protected static abstract class AbstractAlgorithmBuilder<T extends AbstractAlgorithm, B extends AlgorithmBuilder<T>>
    implements AlgorithmBuilder<T> {
        private T algorithm;

        public AbstractAlgorithmBuilder(String algorithmUri) {
            this.algorithm = this.createAlgorithm(algorithmUri);
        }

        @Override
        public T build() {
            this.assertCorrect();
            return this.algorithm;
        }

        public B jcaName(String jcaName) {
            ((AbstractAlgorithm)this.algorithm).setJcaName(jcaName);
            return this.getBuilder();
        }

        public B order(int order) {
            ((AbstractAlgorithm)this.algorithm).setOrder(order);
            return this.getBuilder();
        }

        public B blacklisted(boolean blacklisted) {
            ((AbstractAlgorithm)this.algorithm).setBlacklisted(blacklisted);
            return this.getBuilder();
        }

        protected void assertCorrect() throws IllegalArgumentException {
            if (((AbstractAlgorithm)this.algorithm).getJcaName() == null) {
                throw new IllegalArgumentException("jcaName must be set");
            }
        }

        protected abstract B getBuilder();

        protected abstract T createAlgorithm(String var1);

        protected final T getAlgorithm() {
            return this.algorithm;
        }
    }
}

